package smart_gs.logical;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.DragSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import reasoning_web.logical.Connection;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.logical.filter.ImageFileFilter;
import smart_gs.logical.visitor.CreateXMLElementVisitor;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.CreateSegmentInfoAction; //2007/10/10 kazuhiro kobayashi
import smart_gs.util.StringUtils;
import smart_gs.logical.Preference;

@SuppressWarnings("serial")
public class SpreadTree extends JTree implements DragSourceListener, DropTargetListener, DragGestureListener {

	private static SpreadTree singleton = new SpreadTree();
	private List<Spread> spreads;
	private List<SpreadDirectory> directories;

	// 2007/10/10 kazuhiro kobayashi
	/*
	 * Õt@Cɂimagetextݒ肷邽߂ɕύX
	 */
	// private static final String IMAGE_FOLDER_PATH = "./images/";
	private static String IMAGE_FOLDER_PATH;
	// public static final String TEXT_FOLDER_PATH = "./textDocuments/";
	private static String TEXT_FOLDER_PATH;
	private SpreadDirectory root;
	private DefaultMutableTreeNode rootNode;

	// 2007/11/20 kazuhiro kobayashi
	private static String NAME_CORRESPONDENCE_FILE_PATH;
	private ArrayList<String[]> nameCorrespondList = new ArrayList<String[]>();

	// ADD NorthGrid
	private static final String NAME = "SpreadTree";
	private static final DataFlavor localObjectFlavor = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType, NAME);
	private static final DataFlavor[] supportedFlavors = { localObjectFlavor };
	
	protected DragSource dragSource;
    protected DropTarget dropTarget;
    TreeNode dropTargetNode = null;
    TreeNode draggedNode = null;
    TreePath dragsourceTreePath = null;
    
    protected HashMap<String,String>  allowImageMap = new HashMap<String, String>();
    
    
    private SpreadTree() {
		super(new DefaultMutableTreeNode("root"));

		// C[W̊gqw.
		String formatNames[] = ImageIO.getReaderFormatNames();
		for(int i=0;i<formatNames.length;i++){
			allowImageMap.put(formatNames[i].toLowerCase(), formatNames[i].toLowerCase());
		}

		// 2007/10/22 kazuhiro kobayashi
		Spread.resetIndex();

		this.spreads = new ArrayList<Spread>();
		this.directories = new ArrayList<SpreadDirectory>();
		// 2007/10/11/kazuhiro kobayashi

		IMAGE_FOLDER_PATH = Preference.getInstance().getImageFolderPath();

		TEXT_FOLDER_PATH = Preference.getInstance().getTextFolderPath();

		// 2007/11/20 kazuhiro kobayashi
		NAME_CORRESPONDENCE_FILE_PATH = Preference.getInstance()
				.getNameCorrespondencePath();
		//
		if (!IMAGE_FOLDER_PATH.equals("") && !TEXT_FOLDER_PATH.equals("")) {
			this.root = new SpreadDirectory("root", new File(
					SpreadTree.IMAGE_FOLDER_PATH), new File(
					SpreadTree.TEXT_FOLDER_PATH));
			this.rootNode = new DefaultMutableTreeNode(this.root);
			((DefaultTreeModel) this.getModel()).setRoot(this.rootNode);
			this.loadImages(this.root,true);
			this.updateModel();
		}

		//
		/*
		*20080912 shimizu edited
		if (!NAME_CORRESPONDENCE_FILE_PATH.equals("")){
			this.setNameCorrespondence();
		}
		*/
		// ADD NorthGrid
		setCellRenderer(new SpreadTreeCellRenderer());
		dragSource = new DragSource();
		dragSource.createDefaultDragGestureRecognizer(this, DnDConstants.ACTION_MOVE, this);
		dropTarget = new DropTarget(this, this);
	}

	public List<File> getDSCFiles() {
		List<File> files = new ArrayList<File>();
		for (int i = 0; i < this.spreads.size(); i++) {
			if (this.spreads.get(i).hasDscFile()) {
				files.add(this.spreads.get(i).getDscFile());
			}
		}
		return files;
	}

	public void loadAllImages() {
		for (int i = 0; i < this.spreads.size(); i++) {
			if (this.spreads.get(i).hasDscFile()) {
				this.spreads.get(i).loadImage();

			}

		}
	}

	public void saveLine() {
		for (int i = 0; i < this.spreads.size(); i++) {
			Spread spread = this.spreads.get(i);
			new CreateSegmentInfoAction(spread).createLineFile();
		}
	}

	public static SpreadTree getInstance() {
		return singleton;
	}

	public List<Spread> getSpreads() {
		return this.spreads;
	}

	public void addSpread(Spread spread) {
		this.spreads.add(spread);
	}

	public List<Spread> getDSCSpreads() {
		List<Spread> results = new ArrayList<Spread>();
		for (int i = 0; i < this.spreads.size(); i++) {
			if (this.spreads.get(i).hasDscFile()) {
				results.add(this.spreads.get(i));
			}
		}
		return results;
	}

	public Spread getSelectedSpread() {
		TreePath path = this.getSelectionModel().getSelectionPath();
		if (path == null) {
			return null;
		}
		Object selectedObject = ((DefaultMutableTreeNode) path
				.getLastPathComponent()).getUserObject();
		if (selectedObject instanceof Spread) {
			return (Spread) selectedObject;
		}
		return null;
	}
	
	public SpreadDirectory getSelectedSpreadDirectory() {
		TreePath path = this.getSelectionModel().getSelectionPath();
		if (path == null) {
			return null;
		}
		Object selectedObject = ((DefaultMutableTreeNode) path
				.getLastPathComponent()).getUserObject();
		if (selectedObject instanceof SpreadDirectory) {
			return (SpreadDirectory) selectedObject;
		}
		return null;
	}

	public void remove(){
		WorkspaceWindow.getInstance().close();
		TreePath path = this.getSelectionModel().getSelectionPath();
		if (path == null) {
			return;
		}
		Spread deletespread = getSelectedSpread();
		if (deletespread == null) {
			return;
		}
		String nameStr = deletespread.toString();

		DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode) path.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) targetNode.getParent();

        int smallest = Integer.MAX_VALUE;
		if(nameStr.indexOf(":") != -1){
    		String numberStr = nameStr.substring(0,nameStr.indexOf(":"));
    		try{
    			smallest  = Integer.parseInt(numberStr);
    		}catch(NumberFormatException e){}
		}
        Enumeration enumeration = parentNode.children();
        SpreadDirectory spreadDirectory = (SpreadDirectory)parentNode.getUserObject();
        int deletecount = 0;
        boolean deleteflg = false;
        while(enumeration.hasMoreElements()){
        	DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode)enumeration.nextElement();
        	String childrenStr = childrenNode.toString();
			if(childrenNode.getUserObject() instanceof Spread){
	        	if(childrenStr.equals(nameStr)){
	        		deleteflg = true;
	        		removeLink(((Spread)childrenNode.getUserObject()).getURI());
	        		spreads.remove((Spread)childrenNode.getUserObject());
	        		spreadDirectory.remove((Spread)childrenNode.getUserObject());
	        		break;
	        	}
			}
			deletecount++;
        }
        if(deleteflg){
        	parentNode.remove(deletecount);
        	this.updateUI();
        }else{
        	return;
        }
		for (int i = 0; i < this.spreads.size(); i++) {
			Spread spread = this.spreads.get(i);
        	spread.setPageViewIndex(i);
		}
		removeTree(parentNode);
        repaint();
        this.repaint();
	}
	// efBNg`FbNẴfBNg폜
	public void removeTree(DefaultMutableTreeNode node){
		 SpreadDirectory spreadDirectory = (SpreadDirectory)node.getUserObject();
		List<Spread> list = spreadDirectory.getSpreads();
		if(list.size() == 0){
			directories.remove(spreadDirectory);
			removeLink(spreadDirectory.getURI());
			DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) node.getParent();
			Object  parentObject = parentNode.getUserObject();
			((SpreadDirectory)parentObject).removeDirectory(spreadDirectory);
			parentNode.remove(node);
			new AutomaticNumbering().exec(this.rootNode);		
			this.updateUI();
			removeTree(parentNode);
		}
	}
	
	
	public void removeDirectory(){
		WorkspaceWindow.getInstance().close();

		TreePath path = this.getSelectionModel().getSelectionPath();
		if (path == null) {
			return;
		}
		SpreadDirectory deleteDirectory = getSelectedSpreadDirectory();
		if (deleteDirectory == null) {
			return;
		}
		List<SpreadDirectory> listdir =  deleteDirectory.getSpreadDirectorys();
		for(int i=0;i<listdir.size();i++){
			SpreadDirectory spreadDirectory = (SpreadDirectory)listdir.get(i);
			removeLink(spreadDirectory.getURI());
			directories.remove(spreadDirectory);
		}
		List<Spread> listfile = deleteDirectory.getSpreads();
		for(int i=0;i<listfile.size();i++){
			Spread spread = (Spread)listfile.get(i);
			removeLink(spread.getURI());
			spreads.remove(spread);
		}
		deleteDirectory.removeAllChildren();
		directories.remove(deleteDirectory);
		removeLink(deleteDirectory.getURI());
		DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode) path.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) targetNode.getParent();
        Object  parentObject = parentNode.getUserObject();
		((SpreadDirectory)parentObject).removeDirectory(deleteDirectory);
        ((DefaultMutableTreeNode) targetNode.getParent()).remove(targetNode);

		new AutomaticNumbering().exec(this.rootNode);		
		this.updateUI();
	}
	
	private void removeLink(String url){
		ArrayList<Connection> deleteConnection = new ArrayList<Connection>();
		List<Connection> connectList = GS_RWRepository.getInstance().getConnections();
		for(int i=0;i<connectList.size();i++){
			Connection connection = connectList.get(i);
			RWElement sourceRWElement = connection.getSourcePointer().getElement();
			if(sourceRWElement instanceof GS_RWElement){
				if(((GS_RWElement)sourceRWElement).getURI().startsWith(url)){
					System.out.println(((GS_RWElement)sourceRWElement).getURI());
					deleteConnection.add(connection);
					continue;
				}
			}
			RWElement targetRWElement = connection.getTargetPointer().getElement();
			if(targetRWElement instanceof GS_RWElement){
				if(((GS_RWElement)targetRWElement).getURI().startsWith(url)){
					System.out.println(((GS_RWElement)targetRWElement).getURI());
					deleteConnection.add(connection);
					continue;
				}
			}
		}
		if(deleteConnection.size() != 0){
			for(int i=0;i<deleteConnection.size();i++){
				Connection connection = deleteConnection.get(i);
				GS_RWRepository.getInstance().removeConnection(connection);
			}
		}
	
	}
	public boolean isRegistered(File file) {
		for (int i = 0; i < this.directories.size(); i++) {
			if (this.directories.get(i).getFile().equals(file)) {
				return true;
			}
		}
		for (int i = 0; i < this.spreads.size(); i++) {
			if (this.spreads.get(i).getFile().equals(file)) {
				return true;
			}
		}
		return false;
	}
	
//	public boolean isRegustedTree(File file){
//		for(Enumeration e = rootNode.children(); e.hasMoreElements();){
//			DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
//			GSResource r = (GSResource)child.getUserObject();
//			if( r instanceof SpreadDirectory) {
//				SpreadDirectory d = (SpreadDirectory)r ;
//				if( d.getFile().equals(file) ){
//					return child;
//				}
//			} 
//		}		
//	}

	public SpreadDirectory getCurrentDirectory() {
		TreePath path = this.getSelectionModel().getSelectionPath();
		if (path == null) {
			return (SpreadDirectory) ((DefaultMutableTreeNode) this.getModel()
					.getRoot()).getUserObject();
		}
		Object selectedObject = ((DefaultMutableTreeNode) path
				.getLastPathComponent()).getUserObject();
		while (!(selectedObject instanceof SpreadDirectory)) {
			path = path.getParentPath();
			selectedObject = ((DefaultMutableTreeNode) path
					.getLastPathComponent()).getUserObject();
		}
		return (SpreadDirectory) selectedObject;
	}

	public DefaultMutableTreeNode getSelectedNode() {
		TreePath path = this.getSelectionModel().getSelectionPath();
		if (path == null) {
			return this.rootNode;
		}
		return (DefaultMutableTreeNode) path.getLastPathComponent();
	}

	public boolean isImage(File file){
		String fileName = file.getName();
		int index = fileName.lastIndexOf('.');
		if (index >= 0) { //gqꍇ
			String ext = fileName.substring(index + 1);
			if(allowImageMap.containsKey(ext.toLowerCase())){
				return true;
			}
		}
		return false;
		
	}
	
	private void loadImages(SpreadDirectory parent,boolean sort) {
		File[] files = parent.getFile().listFiles(new ImageFileFilter());
		if(sort){
			Arrays.sort(files, new SpreadFileComparator()); 
		}
		for (int i = 0; i < files.length; i++) {
			File file = files[i];

			if (file.isDirectory()) {
				if (this.isRegistered(file)) {
					SpreadDirectory directory = this.getDirectory(file);
					this.loadImages(directory,sort);
				} else {
					SpreadDirectory directory = new SpreadDirectory(parent,
							file.getName(), file);
					this.directories.add(directory);
					parent.addResource(directory);
					this.loadImages(directory,sort);
				}
			} else if (!this.isRegistered(file)) {
				if(isImage(file)){
					Spread spread = new Spread(parent, file);
					parent.addResource(spread);
					this.spreads.add(spread);
				}
			}
		}
	}
	
	private SpreadDirectory getDirectory(File file) {
		for (int i = 0; i < this.directories.size(); i++) {
			if (this.directories.get(i).getFile().equals(file)) {
				return this.directories.get(i);
			}
		}
		return null;
	}

	public static void main(String[] args) {
		SpreadTree.getInstance();
	}

	public void updateModel() {
		this.root.setTree(this.rootNode);
		((DefaultTreeModel) this.getModel()).setRoot(rootNode);
		((DefaultTreeModel) this.getModel()).reload();
	}

	public void restore(Element element) {
		NodeList list = element.getElementsByTagName("directory");
		if (list.getLength() < 1) {
			System.out.println("list error");
			return;
		}
		Element rootElement = (Element) list.item(0);
		this.spreads.clear();
		this.directories.clear();
		// 2007/10/22 kazuhiro kobayashi
		Spread.resetIndex();
		this.rootNode.removeAllChildren();
		String filepath = rootElement.getAttribute("filename");
		String name = rootElement.getAttribute("name");
		this.root = new SpreadDirectory("root", new File(filepath), new File(
				TEXT_FOLDER_PATH));
		this.root.setName(name);
		this.rootNode.setUserObject(this.root);
		this.root.restore(rootElement);
		spreads = root.getSpreads();
		directories = root.getSpreadDirectorys();
//		this.loadImages(this.root,false);
		this.updateModel();
		//
		/*
		 * 20080912 shimizu edited
		if (!NAME_CORRESPONDENCE_FILE_PATH.equals("")) {
			this.setNameCorrespondence();
		}
		*/
	}

	public void save(Document document, Element parent) {
		Element element = document.createElement("spreadTree");
		parent.appendChild(element);
		CreateXMLElementVisitor visitor = new CreateXMLElementVisitor(document);
		this.root.accept(visitor);
		element.appendChild(visitor.getLastElement());
	}

	public void addSpreadDirectory(SpreadDirectory directory) {
		this.directories.add(directory);
	}

	public Spread getSpreadByURI(String uri) {
		for (int i = 0; i < this.spreads.size(); i++) {
			if (uri.startsWith(spreads.get(i).getURI())) {
				return spreads.get(i);
			}
		}
		return null;
	}

	//
	public void setNameCorrespondence() {
		this.setNameCorrespondenceFile();
		for (int j = 0; j < this.nameCorrespondList.size(); j++) {
			for (int i = 0; i < this.spreads.size(); i++) {
				this.spreads.get(i).setUserName(this.nameCorrespondList.get(j));
			}
			for (int i = 0; i < this.directories.size(); i++) {
				this.directories.get(i).setUserName(
						this.nameCorrespondList.get(j));
			}
		}

	}

	public void setNameCorrespondenceFile() {
		String filename = NAME_CORRESPONDENCE_FILE_PATH;
		try {
			FileReader fr = new FileReader(filename);
			BufferedReader br = new BufferedReader(fr);
			String str1 = null;
			while ((str1 = br.readLine()) != null) {
				String[] str2 = str1.split(",");
				this.nameCorrespondList.add(str2);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	// Add NorhtGrid
	public DefaultMutableTreeNode addDirectory(DefaultMutableTreeNode treeNode,SpreadDirectory parent,File file){
		if (file.isDirectory()) {
			if (!this.isRegistered(file)) {
				SpreadDirectory directory = new SpreadDirectory(parent,	file.getName(), file);
				this.directories.add(directory);
				parent.addResource(directory);
				DefaultMutableTreeNode directoryNode = new DefaultMutableTreeNode(directory);
				treeNode.add(directoryNode);
				return directoryNode;
			}else{
				for(Enumeration e = treeNode.children(); e.hasMoreElements();){
					DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
					GSResource r = (GSResource)child.getUserObject();
					if( r instanceof SpreadDirectory) {
						SpreadDirectory d = (SpreadDirectory)r ;
						if( d.getFile().equals(file) ){
							return child;
						}
					} 
				}
				return null;
			}
		}
		return treeNode;
	}
	public void addLoadImage(DefaultMutableTreeNode treeNode,SpreadDirectory parent,File file){
		if (!file.isDirectory()) {
			if (!this.isRegistered(file)) {
				if(this.isImage(file)){
					{
						Spread spread = new Spread(parent, file);
						parent.addResource(spread);
						this.spreads.add(spread);
						treeNode.add(new DefaultMutableTreeNode(spread));
					}
					new AutomaticNumbering().exec(this.rootNode);		
				}
			}
		}
		this.updateUI();
	}
	public void export(Writer writer) throws IOException{
		for (int i = 0; i < this.spreads.size(); i++) {
			Spread spread = this.spreads.get(i);
			boolean isBr = false;
			// Transcription
			{
				String xmlstr = spread.getTranscription().getSource();
				xmlstr = StringUtils.replaceString(xmlstr, "<br>", "\n");
				Pattern pattern = Pattern.compile("<.+?>", Pattern.DOTALL);
		        Matcher matcher = pattern.matcher(xmlstr);
		        xmlstr = matcher.replaceAll("");
		        xmlstr = xmlstr.trim();
		        if(!xmlstr.trim().equals("")){
			        writer.write(xmlstr);
			        writer.write("\n");
			        isBr = true;
		        }
			}
			// Annotation
			{
				String xmlstr = spread.getAnnotation().getSource();
				xmlstr = StringUtils.replaceString(xmlstr, "<br>", "\n");
				Pattern pattern = Pattern.compile("<.+?>", Pattern.DOTALL);
		        Matcher matcher = pattern.matcher(xmlstr);
		        xmlstr = matcher.replaceAll("");
		        xmlstr = xmlstr.trim();
		        if(!xmlstr.trim().equals("")){
			        writer.write(xmlstr);
			        writer.write("\n");
			        isBr = true;
		        }
			}
			// Translation
			{
				String xmlstr = spread.getTranslation().getSource();
				xmlstr = StringUtils.replaceString(xmlstr, "<br>", "\n");
				Pattern pattern = Pattern.compile("<.+?>", Pattern.DOTALL);
		        Matcher matcher = pattern.matcher(xmlstr);
		        xmlstr = matcher.replaceAll("");
		        xmlstr = xmlstr.trim();
		        if(!xmlstr.trim().equals("")){
			        writer.write(xmlstr);
			        writer.write("\n");
			        isBr = true;
		        }
			}
			if(isBr){
		        writer.write("\n");
			}
		}
	}
	// ADD NorthGrid ȉD&DCxg
	/**
	 * hbOhbv삪.
	 * @param dsde
	 */
	public void dragDropEnd(DragSourceDropEvent dsde) {
        dropTargetNode = null;
        draggedNode = null;
        dragsourceTreePath = null;
        // ĕ\
        repaint();
    }
	/**
	 * J[\̃zbgX|bgvbgtH[ˑ̃hbvTCgɓ͂ꂽ.
	 * @param dsde
	 */
    public void dragEnter(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
    }
    /**
     * J[\̃zbgX|bgvbgtH[ˑ̃hbvTCgIƂ.
     * @param dse
     */
    public void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }
    /**
     * hbvTCgɈړ.
     * @param dsde
     */
    public void dragOver(DragSourceDragEvent dsde) {}
    /**
     * WFX`[ύX.
     * @param dsde
     */
    public void dropActionChanged(DragSourceDragEvent dsde) {}
    /**
     * hbN󂯓ꂽƂ.
     * @param dtde
     */
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);
    }
    /**
     * hbOI.
     * @oaram dte
     */
    public void dragExit(DropTargetEvent dte) {}
    /**
     * hbȌ.
     * @prama dtde
     */
    public void dragOver(DropTargetDragEvent dtde) {
        DataFlavor[] f = dtde.getCurrentDataFlavors();
        boolean isDataFlavorSupported = f[0].getHumanPresentableName().equals(NAME);
        if(!isDataFlavorSupported) {
            //T|[gĂȂDataFlavorł(Ⴆ΃fXNgbvt@CȂ)
            rejectDrag(dtde);
            return;
        }
        Point pt = dtde.getLocation();
        TreePath path = getPathForLocation(pt.x, pt.y);
        if(path==null) {
            //m[hȊȌꏊł(ႦJTree̗]Ȃ)
            rejectDrag(dtde);
            return;
        }
        Object droppedObject;
        try {
            droppedObject = dtde.getTransferable().getTransferData(localObjectFlavor);
        }catch(Exception ex) {
            rejectDrag(dtde);
            return;
        }
        // ʃfBNgւ̈ړ͋֎~
        if(!path.getParentPath().toString().equals(dragsourceTreePath.getParentPath().toString())){
            rejectDrag(dtde);
            return;
        }
        MutableTreeNode droppedNode       = (MutableTreeNode) droppedObject;
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode) path.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) targetNode.getParent();
        while(parentNode!=null) {
            if(droppedNode.equals(parentNode)) {
                //em[hqm[hɃhbv悤ƂĂ
                rejectDrag(dtde);
                return;
            }
            parentNode = (DefaultMutableTreeNode)parentNode.getParent();
        }
        dropTargetNode = targetNode;
        dtde.acceptDrag(dtde.getDropAction());
        repaint();
    }
    /**
     *  DropTarget ւ̃hbvŁAhbO삪I.
     *  @param dtde
     */
    public void drop(DropTargetDropEvent dtde) {
        Object droppedObject;
        try {
            droppedObject = dtde.getTransferable().getTransferData(localObjectFlavor);
        }catch(Exception e) {
            e.printStackTrace();
            dtde.dropComplete(false);
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel) getModel();
        Point p = dtde.getLocation();
        TreePath path = getPathForLocation(p.x, p.y);
        if(path==null || !(droppedObject instanceof MutableTreeNode)) {
            dtde.dropComplete(false);
            return;
        }
        MutableTreeNode droppedNode       = (MutableTreeNode) droppedObject;
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode) path.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) targetNode.getParent();
        if(targetNode.equals(droppedNode)) {
            //ɂ̓hbvs
            dtde.dropComplete(false);
            return;
        }
        dtde.acceptDrop(DnDConstants.ACTION_MOVE);
        model.removeNodeFromParent(droppedNode);
        if(parentNode!=null && targetNode.isLeaf()) {
            model.insertNodeInto(droppedNode, parentNode, parentNode.getIndex(targetNode));
        }else{
            model.insertNodeInto(droppedNode, targetNode, targetNode.getChildCount());
        }
        dtde.dropComplete(true);
        
        Enumeration enumeration = parentNode.children();
        // ԏmF
        int smallest = Integer.MAX_VALUE;
        while(enumeration.hasMoreElements()){
        	DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode)enumeration.nextElement();
        	String childrenStr = childrenNode.toString();
			if(childrenNode.getUserObject() instanceof Spread){
	        	if(childrenStr.indexOf(":") != -1){
	        		String numberStr = childrenStr.substring(0,childrenStr.indexOf(":"));
	        		try{
	        			int number  = Integer.parseInt(numberStr);
	        			if(smallest > number){
	        				smallest = number;
	        			}
	        		}catch(NumberFormatException e){}
	        	}
			}else if(childrenNode.getUserObject() instanceof SpreadDirectory){
				// Ȃ
			}
        }
        // ēxlUȂ
        enumeration = parentNode.children();
        int i = smallest;
        while(enumeration.hasMoreElements()){
        	DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode)enumeration.nextElement();
        	String childrenStr = childrenNode.toString();
			if(childrenNode.getUserObject() instanceof Spread){
	        	Spread spread = (Spread)childrenNode.getUserObject();
	        	spread.setPageViewIndex(i);
			}else if(childrenNode.getUserObject() instanceof SpreadDirectory){
				// Ȃ
			}
			i++;
        }
        // \[g
        if(parentNode.getUserObject() instanceof SpreadDirectory){
        	((SpreadDirectory)parentNode.getUserObject()).sort();
        }
        // MoveTooBarAbvf[g
        WorkspaceWindow.getInstance().updateMoveToolBar();
    }
    /**
     * WFX`[ύX.
     * @param dtde
     */
    public void dropActionChanged(DropTargetDragEvent dtde) {}

    /**
     * D&D̑JnB
     * @param dge hbOJnWFX`[oCxg
     */
    public void dragGestureRecognized(DragGestureEvent dge) {
        Point clickPoint = dge.getDragOrigin();
        TreePath path = getPathForLocation(clickPoint.x, clickPoint.y);
        if(path==null || path.getParentPath()==null) {
            return;
        }
        dragsourceTreePath = path;
        draggedNode = (TreeNode) path.getLastPathComponent();
        if(draggedNode instanceof DefaultMutableTreeNode){
        	if(((DefaultMutableTreeNode)draggedNode).getUserObject() instanceof Spread ){
                Transferable trans = new SpreadTreeTransferable(draggedNode);
                dragSource.startDrag(dge,Cursor.getDefaultCursor(),
                        trans, this);
        	}
        }
    }
    /**
     * hbN̒~.
     * @param dtde
     */
    private void rejectDrag(DropTargetDragEvent dtde) {
        dtde.rejectDrag();
        // dropTargetNode(flag)null
        dropTargetNode = null;
        //JTree`
        repaint();
    }
    /**
     * 
     * f[^ϊNX.
     * AvȊÕhbN`FbN.
     */
	 class SpreadTreeTransferable implements Transferable {
	        Object object;
	        public SpreadTreeTransferable(Object o) {
	            object = o;
	        }
	        //@Override
	        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
	            if(isDataFlavorSupported(df)) {
	                return object;
	            }else{
	                throw new UnsupportedFlavorException(df);
	            }
	        }
	        //@Override
	        public boolean isDataFlavorSupported(DataFlavor df) {
	            return (df.getHumanPresentableName().equals(NAME));
	        }
	        //@Override
	        public DataFlavor[] getTransferDataFlavors() {
	            return supportedFlavors;
	        }
    }
	 /**
	  * 
	  * RendererNX
	  * D&D̑Ctĕ\.
	  *
	  */
	class SpreadTreeCellRenderer
	            extends DefaultTreeCellRenderer {
	        boolean isTargetNode;
	        boolean isTargetNodeLeaf;
	        boolean isLastItem;
	        Insets normalInsets, lastItemInsets;
	        int BOTTOM_PAD = 30;
	        public SpreadTreeCellRenderer() {
	            super();
	            normalInsets = super.getInsets();
	            lastItemInsets =
	                    new Insets(normalInsets.top,
	                    normalInsets.left,
	                    normalInsets.bottom + BOTTOM_PAD,
	                    normalInsets.right);
	        }
	        public Component getTreeCellRendererComponent(JTree tree,
	                Object value,
	                boolean isSelected,
	                boolean isExpanded,
	                boolean isLeaf,
	                int row,
	                boolean hasFocus) {
	            isTargetNode = (value == dropTargetNode);
	            isTargetNodeLeaf = (isTargetNode &&
	                    ((TreeNode)value).isLeaf());
	            // isLastItem = (index == list.getModel().getSize()-1);
	            boolean showSelected = isSelected & (dropTargetNode == null);
	            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded,isLeaf, row, hasFocus);
	            if(value != null){
		            if(value instanceof DefaultMutableTreeNode){
		            	DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)value;
		            	Object obj = defaultMutableTreeNode.getUserObject();
		            	if(obj != null){
		            		if(obj instanceof SpreadDirectory){
			            		Icon icon = renderer.getOpenIcon();
			            		renderer.setIcon(icon);
		            		}
		            	}
		            }
	            }
	            return renderer;
	            
	        }
	        
	        public void paintComponent(Graphics g) {
	            super.paintComponent(g);
	            if (isTargetNode) {
	                g.setColor(Color.black);
	                if (isTargetNodeLeaf) {
	                    g.drawLine(0, 0, getSize().width, 0);
	                } else {
	                    g.drawRect(0, 0, getSize().width-1, getSize().height-1);
	                }
	            }
	        }
	    }

	class SpreadFileComparator implements Comparator<File>{

		public int compare(File o1, File o2) {
			return o1.compareTo(o2);
		}
		
	}
	
	class 	AutomaticNumbering {
		private int counter = 0;
		private void exec(DefaultMutableTreeNode parentNode){
			Enumeration enumeration = parentNode.children();
	        while(enumeration.hasMoreElements()){
	        	DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode)enumeration.nextElement();
	        	String childrenStr = childrenNode.toString();
				if(childrenNode.getUserObject() instanceof Spread){
		        	Spread spread = (Spread)childrenNode.getUserObject();
		        	spread.setPageViewIndex(counter);
					counter++;
				}else if(childrenNode.getUserObject() instanceof SpreadDirectory){
					exec(childrenNode);
				}
	        }
		}
	}

}
