package smart_gs.logical;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import smart_gs.drawing_tool.view.View;
import smart_gs.logical.visitor.Visitor;
import smart_gs.util.XMLToLineConverter;
import smart_gs.logical.Preference;

public class Spread extends GSResource {

	private SpreadDirectory volume;
	private ImageIcon imageIcon;
	private int width;
	private int height;
	private File file;
	/*
	 * ݕ\lineregion
	 */
	private List<LineSegment> lines;
	private List<Region> regions;

	private List<Sheet> sheets;
	private Sheet currentSheet;

	private File dscFile;
	private TranscriptionDocument transcription;
	private AnnotationDocument annotation;
	private TranslationDocument translation;
	// 2007/10/11 kazuhiro kobayashi
	/*
	 * Odsct@Cg߂ɕύX
	 */
	// public static final String DSC_FOLDER_PATH = "./dsc/";
	// public static String LINE_FOLDER_PATH = "./lines/";
	public static String DSC_FOLDER_PATH = Preference.getInstance()
			.getDscFolderPath();
	public static String LINE_FOLDER_PATH = Preference.getInstance()
			.getLineFolderPath();

	private String writer = "unknown";

	private int leftIndex; // pageԍ
	private int rightIndex;

	private static int index = 0;
	
	//2007/10/22 kazuhiro kobayashi
	private static int pageIndex = 0;
	private int _pageIndex;
	// ADD NorthGrid
	// \p̃CfbN
	// pageIndexύXƉeo\̂ŎbIɐݒu
	// pageIndex͍őlƍŏl̃`FbNɂgĂȂ݂Ȃ̂
	// 㓝
	private int _pageVIewIndex;
	
	
	
	public Spread(SpreadDirectory volume, File file) {
		super(volume.getURI() + getFileNameWithoutExtension(file) + "/");
		this.regions = new ArrayList<Region>();
		this.volume = volume;
		this.file = file;
		this.transcription = new TranscriptionDocument(this);
		this.annotation = new AnnotationDocument(this);
		this.translation = new TranslationDocument(this);
		this.checkDscFile();
		this.loadLines();
		this.setId(this.hashCode());

		this.sheets = new ArrayList<Sheet>();
		currentSheet = makeSheet();

		this.leftIndex = index++;
		this.rightIndex = index++;
		
		//2007/10/22 kazuhiro kobayashi 
		this._pageVIewIndex = this._pageIndex = pageIndex++;
		//2007/11/20 kazuhiro kobayashi
		this.systemName = this.getFile().getName();
		if(this.userName==null){
			this.userName = this.getFileNameWithoutExtension();
		}
		//
		// this.setURI(volume.getURI()+this.leftIndex+"-"+this.rightIndex+"/");
	}

	private static String getFileNameWithoutExtension(File file) {
		String str = file.getName();
		int index = str.lastIndexOf('.');
		return str.substring(0, index);
	}

	public File getFile() {
		return this.file;
	}

	public void loadLines() {
		if (this.lines == null) {
			String filename = DSC_FOLDER_PATH + this.volume.getPath()
					+ this.getFileNameWithoutExtension() + ".xml";
			File file = new File(filename);
			if (!file.exists()) {
				this.lines = new ArrayList<LineSegment>();
				return;
			}
			this.lines = new XMLToLineConverter(this).getLines(new File(
					filename));
		}
	}

	void loadImage() {
		this.imageIcon = new ImageIcon(this.file.getAbsolutePath());
		this.width = this.imageIcon.getIconWidth();
		this.height = this.imageIcon.getIconHeight();
	}

	public int getWidth() {
		if (this.imageIcon == null) {
			this.loadImage();
		}
		return this.width;
	}

	public int getHeight() {
		if (this.imageIcon == null) {
			this.loadImage();
		}
		return this.height;
	}

	public Image getImage() {
		if (this.imageIcon == null) {
			this.loadImage();
		}
		return this.imageIcon.getImage();
	}

	public ImageIcon getImageIcon() {
		if (this.imageIcon == null) {
			this.loadImage();
		}
		return imageIcon;
	}

	public void addRegion(Region region) {
		this.regions.add(region);
		// kazuhiro kobayashi 10/5
		// currentSheet.addNormalRegions(region);
		currentSheet.addRegion(region);
	}

	public List<Region> getRegions() {
		return this.regions;
	}

	public void addLineSegment(LineSegment line) {
		this.lines.add(line);
	}

	public List<LineSegment> getLines() {
		if (this.lines == null) {
			this.loadLines();
		}
		return this.lines;
	}

	public SpreadDirectory getVolume() {
		return this.volume;
	}

	public String getFileNameWithoutExtension() {
		int index = file.getName().lastIndexOf('.');
		return file.getName().substring(0, index);
	}

	public String toString() {
		//2007/10/22 kazuhiro kobayashi
		//2007/11/20
//		String str = this._pageIndex +": " + this.userName;
		// ADD NorthGird
		String str = this._pageVIewIndex +": " + this.userName;
//		String str = this._pageIndex +": " + this.getFileNameWithoutExtension();
//		String str = this.getFileNameWithoutExtension();
		if (this.dscFile != null) {
			str += (" (SEARCH)");
		}
		return str;
	}
	
	public String getViewName(){
		String str =  this.userName;
		if (this.dscFile != null) {
			str += (" (SEARCH)");
		}
		return str;
	}

	public TranscriptionDocument getTranscription() {
		return this.transcription;
	}

	public AnnotationDocument getAnnotation() {
		return this.annotation;
	}

	public TranslationDocument getTranslation() {
		return this.translation;
	}

	public void setTranscription(TranscriptionDocument transcription) {
		this.transcription = transcription;
	}

	public void setAnnotation(AnnotationDocument annotation) {
		this.annotation = annotation;
	}

	public void setTranslation(TranslationDocument translation) {
		this.translation = translation;
	}

	public boolean hasDscFile() {
		if (this.dscFile == null) {
			return false;
		} else {
			return true;
		}
	}

	public List<Region> getSelectedRegions() {
		List<Region> results = new ArrayList<Region>();
		for (int i = 0; i < this.regions.size(); i++) {
			View view = this.regions.get(i).getView();
			if (view.isSelected()) {
				results.add(this.regions.get(i));
			}
		}
		return results;
	}

	public void clearSelection() {
		for (int i = 0; i < this.regions.size(); i++) {
			View view = this.regions.get(i).getView();
			view.setIsSelected(false);
			view.setIsEmphasized(false);
		}
	}

	private void checkDscFile() {
		String folderPath = DSC_FOLDER_PATH + this.volume.getPath() + "/dsc/";
		this.dscFile = new File(folderPath + this.getFileNameWithoutExtension()
				+ ".dsc");
		if (!this.dscFile.exists()) {
			this.dscFile = null;
		}
	}

	public File getDscFile() {
		String folderPath = DSC_FOLDER_PATH + this.volume.getPath() + "/dsc/";
		this.dscFile = new File(folderPath + this.getFileNameWithoutExtension()
				+ ".dsc");
		if (!this.dscFile.exists()) {
			this.dscFile = null;
			return null;
		}
		return this.dscFile;
	}

	public void removeRegion(Region region) {
		boolean isRemoved = this.regions.remove(region);
		if (!isRemoved) {
			this.lines.remove(region);
		}
	}

	public void release() {
		if (Preference.getInstance().shouldLoadAll()) {
			return;
		}
		if (this.imageIcon == null) {
			return;
		}
		this.imageIcon.getImage().flush();
		this.imageIcon = null;
	}

	public Region getRegionByURI(String uri) {
		for (int i = 0; i < this.regions.size(); i++) {
			if (this.regions.get(i).getURI().equals(uri)) {
				return this.regions.get(i);
			}
		}
		return null;
	}

	public GSResource getResource(String uri) {
		if (this.uri.equals(uri)) {
			return this;
		} else if (transcription.uri.equals(uri)) {
			return transcription;
		} else if (translation.uri.equals(uri)) {
			return translation;
		} else if (annotation.uri.equals(uri)) {
			return annotation;
		}

		if (uri.startsWith(transcription.uri)) {
			return transcription.getTextSegmentByURI(uri);
		} else if (uri.startsWith(translation.uri)) {
			return translation.getTextSegmentByURI(uri);
		} else if (uri.startsWith(annotation.uri)) {
			return annotation.getTextSegmentByURI(uri);
		}

		return this.getRegionByURI(uri);
	}

	public String getFolderPath() {
		return this.volume.getPath();
	}

	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}

	public int getLeftIndex() {
		return leftIndex;
	}

	public int getRightIndex() {
		return rightIndex;
	}

	public void setLeftIndex(int leftIndex) {
		this.leftIndex = leftIndex;
	}

	public void setRightIndex(int rightIndex) {
		this.rightIndex = rightIndex;
	}

	public String getWriter() {
		return writer;
	}

	public void setWriter(String writer) {
		this.writer = writer;
	}

	// ----------------region̕\Ɋւ郁\bh--------------------------------------//
	/*
	 * getProtectedRegions(),getNoRegions(),getAllRegions()\bhɂA
	 * K؂regionssheet瓾邱Ƃŕ\ςB
	 * 
	 * 2007/9/20
	 * 
	 * kazuhiro kobayashi 10/5 ȉ̃\bhC
	 */
	/*
	 * V[gshoewRegion̏ԂɉēK؂regions\郁\bh
	 */

	public void showRegions() {
		if (currentSheet.getShowRegion() == Sheet.SHOW_PROTECTED_REGIONS) {
			regions = currentSheet.getProtectedRegions();
		} else if (currentSheet.getShowRegion() == Sheet.SHOW_NO_REGIONS) {
			// regions = currentSheet.getNoRegions();
			regions = new ArrayList<Region>();
		} else if (currentSheet.getShowRegion() == Sheet.SHOW_ALL_REGIONS) {
			regions = currentSheet.getAllRegions();
		}
	}

	/*
	 * V[gshowRegions̏Ԃς߂
	 */
	public void changeShowRegionAttribute() {
		if (currentSheet.getShowRegion() == Sheet.SHOW_NO_REGIONS) {
			currentSheet.setShowRegion(Sheet.SHOW_ALL_REGIONS);
		} else if (currentSheet.getShowRegion() == Sheet.SHOW_ALL_REGIONS) {
			currentSheet.setShowRegion(Sheet.SHOW_PROTECTED_REGIONS);
		} else if (currentSheet.getShowRegion() == Sheet.SHOW_PROTECTED_REGIONS) {
			currentSheet.setShowRegion(Sheet.SHOW_NO_REGIONS);
		}
	}

	public void changeShowRegion() {
		this.changeShowRegionAttribute();
		showRegions();
	}

	// ----------V[g̑IɊւ郁\bh----------------------------------------//

	/*
	 * VV[g쐬ăXgɉ郁\bh
	 */
	public Sheet makeSheet() {
		List<Region> regions = new ArrayList<Region>();
		Sheet sheet = new Sheet(regions, this);
		if (sheets.size() != 0) {
			setNewSheetName(sheet);
		}
		sheets.add(sheet);
		return sheet;
	}

	/*
	 * V[gw肵Ĉړ郁\bh
	 */
	public void _selectSheet(Sheet sheet) {
		// distinguishNormalOrProtected();
		currentSheet = sheet;
		showRegions();
	}

	/*
	 * ̃V[gɈړ郁\bh
	 */
	public void roundSheet() {
		int i = sheets.indexOf(currentSheet);
		if (i + 1 < sheets.size()) {
			_selectSheet(sheets.get(i + 1));
		} else {
			_selectSheet(sheets.get(0));
		}
	}

	/*
	 * V[g̖O
	 */
	public void setNewSheetName(Sheet sheet) {
		String sheetName = (String) JOptionPane
				.showInputDialog("Input sheet name");
		sheet.setSheetName(sheetName);
	}

	/*
	 * ÕNX̑ɎgB
	 */
	public List<Sheet> getSheets() {
		return this.sheets;
	}

	public Sheet getCurrentSheet() {
		return this.currentSheet;
	}

	public void setCurrentSheet(Sheet sheet) {
		this.currentSheet = sheet;
	}
	
	
	public static void resetIndex(){
		Spread.pageIndex = 0;
	}
	// ADD NorthGrid
	/**
	 * \pCfbNXݒ
	 */
	public void setPageViewIndex(int number){
		_pageVIewIndex = number;
	}
	// ADD NorthGrid
	/**
	 * \pCfbNX擾
	 */
	public int getPageViewIndex(){
		return _pageVIewIndex;
	}
	public int getPageIndex(){
		return this._pageIndex;
	}
}
