/* $Id: DefaultToolBar.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.action.LineSegEditorChangeSizeAction;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.ImageToolBarComponent.IMAGETOOLBARCOMPONENT_TYPE;
import smart_gs.swingui.toolbar.action.DeleteDscFileAction;
import smart_gs.swingui.toolbar.action.DeleteLineSegmentsFileAction;
import smart_gs.swingui.toolbar.action.LineSegEditorChangeIndexActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorCutActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDefaultActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDeleteActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorDrawActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorMoveActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorSemiAutomaticLineSegmentationActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorUndoActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorZoomInOutActionListener;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsAction;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsInSegfoFormatAction;
import smart_gs.swingui.toolbar.action.SelectLineSegModeActionListener;
import smart_gs.swingui.toolbar.action.DscCompileAction;
import smart_gs.swingui.toolbar.action.ImportDscFileAction;
import smart_gs.swingui.toolbar.action.LineSegDscInformationAction;
import smart_gs.swingui.toolbar.action.LineSegEditorShowLinesActionListener;
import smart_gs.swingui.toolbar.action.OpenActionListener;
import smart_gs.swingui.toolbar.action.ReadSegmentInfoAction;
import smart_gs.swingui.toolbar.action.SaveActionListener;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsAndDscCompileAction;
import smart_gs.swingui.toolbar.action.ShowLinesActionListener;

@SuppressWarnings("serial")
public class LineSegEditorToolBar extends JToolBar{

	ButtonGroup modeButtonGroup;
	JRadioButton defaultbutton;
	JRadioButton draw;
	JRadioButton cut;

	public LineSegEditorToolBar(LineSegEditor editor){

		modeButtonGroup = new ButtonGroup();

		defaultbutton = new JRadioButton("Default");
		defaultbutton.addActionListener(new LineSegEditorDefaultActionListener(editor));
		defaultbutton.setToolTipText("Default Mode");
		this.add(defaultbutton);
		modeButtonGroup.add(defaultbutton);

		draw = new JRadioButton("Draw");
		draw.addActionListener(new LineSegEditorDrawActionListener(editor));
		draw.setToolTipText("Draw Line Segment Mode");
		this.add(draw);
		modeButtonGroup.add(draw);

		draw = new JRadioButton("Auto");
		draw.addActionListener(new LineSegEditorSemiAutomaticLineSegmentationActionListener(editor));
		draw.setToolTipText("Semi-auto Draw Line Segment Mode");
		this.add(draw);
		modeButtonGroup.add(draw);

		cut = new JRadioButton("Cut");
		cut.addActionListener(new LineSegEditorCutActionListener(editor,this));
		cut.setToolTipText("Cut Line Segment");
		this.add(cut);
		modeButtonGroup.add(cut);

		JButton move = new JButton("Change");
		move.addActionListener(new LineSegEditorChangeIndexActionListener(editor));
		move.setToolTipText("Change Index");
		this.add(move);

		JButton delete = new JButton("Delete");
		delete.addActionListener(new LineSegEditorDeleteActionListener(editor));
		delete.setToolTipText("Delete Line");
		this.add(delete);

		JButton undo = new JButton("Undo");
		undo.addActionListener(new LineSegEditorUndoActionListener(editor));
		undo.setToolTipText("Undo the last change on line segments");
		this.add(undo);

		JButton linesegshow = new JButton(new ImageIcon(GSConstants.ICON_PATH+"linesegment.png"));
		linesegshow.addActionListener(new LineSegEditorShowLinesActionListener(editor));
		linesegshow.setToolTipText("Line Segment Display Mode");
		this.add(linesegshow);

		JButton zoomIn = new ZoomIn(new ImageIcon(GSConstants.ICON_PATH+"zoom_in.gif"));
		zoomIn.addActionListener(new LineSegEditorZoomInOutActionListener(editor,"ZoomIn"));
		zoomIn.setToolTipText("Zoom in");
		this.add(zoomIn);

		JButton zoomOut = new ZoomOut(new ImageIcon(GSConstants.ICON_PATH+"zoom_out.gif"));
		zoomOut.addActionListener(new LineSegEditorZoomInOutActionListener(editor,"ZoomOut"));
		zoomOut.setToolTipText("Zoom out");
		this.add(zoomOut);

		JButton changeSize = new JButton("Zoom & Move");
		changeSize.addActionListener (new LineSegEditorChangeSizeAction(editor));
		changeSize.setToolTipText("Change Size");
		this.add(changeSize);

		JButton saveLSeg = new JButton("Save");
		saveLSeg.addActionListener(new SaveLineSegmentsAction(editor));
		saveLSeg.setToolTipText("Save Line Segments");
		this.add(saveLSeg);

		JButton readLSegSegfo = new JButton("Read Segfo File");
		readLSegSegfo.addActionListener(new ReadSegmentInfoAction(editor));
		readLSegSegfo.setToolTipText("Read Segfo File");
		this.add(readLSegSegfo);

		JButton saveLSegSegfo = new JButton("Save as Segfo File");
		saveLSegSegfo.addActionListener(new SaveLineSegmentsInSegfoFormatAction(editor));
		saveLSegSegfo.setToolTipText("Save as Segfo File");
		this.add(saveLSegSegfo);

		JButton infoLSeg = new JButton("Line Seg & DSC Info");
		infoLSeg.addActionListener(new LineSegDscInformationAction(editor));
		infoLSeg.setToolTipText("Line Seg & DSC Information");
		this.add(infoLSeg);

		JButton deleteLSeg = new JButton("Delete Line Seg File");
		deleteLSeg.addActionListener(new DeleteLineSegmentsFileAction(editor));
		deleteLSeg.setToolTipText("Delete Line Segments File");
		this.add(deleteLSeg);

		JButton createDSC = new JButton("Make DSC File");
		createDSC.addActionListener(new DscCompileAction(editor));
		createDSC.setToolTipText("Make DSC File");
		this.add(createDSC);

		JButton createLineSegAndDSC = new JButton("Save Line Seg & Make DSC File");
		createLineSegAndDSC.addActionListener(new SaveLineSegmentsAndDscCompileAction(editor));
		createLineSegAndDSC.setToolTipText("Save Line Seg & Make DSC File");
		this.add(createLineSegAndDSC);

		JButton deleteDSC = new JButton("Delete DSC File");
		deleteDSC.addActionListener(new DeleteDscFileAction(editor));
		deleteDSC.setToolTipText("Delete DSC File");
		this.add(deleteDSC);

		JButton importDSC = new JButton("Import DSC File");
		importDSC.addActionListener(new ImportDscFileAction(editor));
		importDSC.setToolTipText("Import DSC File");
		this.add(importDSC);

	}

	public void initializeButtonGroup () {
		defaultbutton.setEnabled(true);
		draw.setEnabled(true);
		cut.setEnabled(true);
		defaultbutton.setSelected(true);
	}

	public void disableDefautlAndDraw() {
		defaultbutton.setEnabled(false);
		draw.setEnabled(false);
	}

	private class ZoomIn extends JButton implements ImageToolBarComponent {

		ZoomIn(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.ZOOM_IN;
		}
	}

	private class ZoomOut extends JButton implements ImageToolBarComponent {

		ZoomOut(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.ZOOM_OUT;
		}
	}


}
