/* $Id: SearchDialog.java 636 2013-01-27 02:58:17Z shayashi $ */
package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import smart_gs.image_search.normal.swingui.ImageSearchPanel;
import smart_gs.logical.Region;
import smart_gs.text_search.swingui.TextSearchPanel;

public class SearchDialog extends JDialog {
	private static final long serialVersionUID = 1L;

	JPanel panel1;
	JPanel panel2;
	
	public SearchDialog (Region region) {
		super(new JFrame(), "Search");
		SetIcon.setIcon(this);
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);

		JTabbedPane searchTab = new JTabbedPane();

		panel1 = new ImageSearchPanel(region);

		((ImageSearchPanel)panel1).setSearchDialog(this);
		panel2 = new TextSearchPanel();
		
		searchTab.addTab("Image Search", panel1);
		searchTab.addTab("Global Text Search", panel2);
		
		mainPanel.add(searchTab);
	}

}
