/* $Id: GSWysiwygMouseListener.java 645 2013-02-02 02:19:30Z minao $ */
package smart_gs.smleditor.swingui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;

import org.w3c.dom.Element;

import smart_gs.connection.ConnectionCreator;
import smart_gs.current_text_search.CurrentSearchTextWithoutDialog;
import smart_gs.debugprint.Debugprint;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.action.JumpWebPageAction;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceTabbedPane;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;
import smart_gs.util.HrefChecker;
import smart_gs.util.WindowByMouseEvent;
import sml_editor.swingui.GSHTMLEditorTextPane;
import sml_editor.swingui.wysiwyg.WysiwygMouseListener;


public class GSWysiwygMouseListener extends WysiwygMouseListener {
	// ADD NorthGird 20090224
	protected boolean markupflg = false;
	
	public GSWysiwygMouseListener(GSEditorTextPane textPane) {
		super(textPane);
	}
	@Override
	public void mouseClicked(MouseEvent e) {
		super.mouseClicked(e);
		if(e.getButton() == MouseEvent.BUTTON3 ||
				/* alternative for right button click */
				(e.getButton() == MouseEvent.BUTTON1 & WorkspaceWindow.getInstance().isAlt())){
			SimpleAttributeSet element = textPane.getSelectID(e.getPoint());
			if(element == null){
				JComponent component = ( JComponent ) e.getSource();
				new GSEditorPopupMenu2(textPane).show(textPane,e.getX() + component.getX(),e.getY() + component.getY());
				return;
			}
			
			boolean href = false;
			String id = (String)element.getAttribute(HTML.Attribute.HREF);
			TextSegment segment = null;
			if(id != null){
				int checkid = HrefChecker.check(id);
				if(checkid == -1){
					href = true;
				}else{
					segment = ((GSEditorTextPane)textPane).getSmartDocument().getSegmentByID(checkid);
				}
				/*
				 * show popup
				 */
				JComponent component = ( JComponent ) e.getSource();
				new GSEditorPopupMenu(segment,textPane,e.getPoint(),href).show(textPane,e.getX() + component.getX(),e.getY() + component.getY());

			}
		}
		if(e.getButton() == MouseEvent.BUTTON1){
			SimpleAttributeSet element = textPane.getSelectID(e.getPoint());
			if(element == null){
				if (e.getClickCount()==2) {
					jumpToCorrespondingLineInImage(e);
				}
				return;
			}
			TextSegment segment =  null;
			String id = (String)element.getAttribute(HTML.Attribute.HREF);
			int checkid = HrefChecker.check(id);
			
			//2011/10/16 kukita
			if (element.getAttribute(ConnectionCreator.EXTERNAL_LINK) != null) {
				new JumpWebPageAction(textPane,e.getPoint()).actionPerformed(null);
				return;
			}else{
				segment = ((GSEditorTextPane)textPane).getSmartDocument().getSegmentByID(checkid);
			}
			if(segment != null){
				if(WorkspaceWindow.getInstance().isAlt() == true && WorkspaceWindow.getInstance().isCtrl() == true){
					new ShowLocalViewAction(segment).execute();
				}else if(WorkspaceWindow.getInstance().isAlt()){
					ConnectionCreator.setSource(segment);
				}else if(WorkspaceWindow.getInstance().isCtrl()){
					ConnectionCreator.setTarget(segment);
				}
				if(e.getClickCount() == 2){
					new ShowLocalViewAction(segment).execute();
				}
			}
		}
	}
	
	private void jumpToCorrespondingLineInImage(MouseEvent e) {
		AbstractGSWindow window = (new WindowByMouseEvent()).getWindow(e);
		if (window == null) return;
		boolean iscompacteditor=false;
		if (window instanceof GSEditor) {
			if (((GSEditor)window).getEditorType() == GSEditor.COMPACT) {
				iscompacteditor=true;
			}
		}
		GSTabbedPane gsTabbedPane = window.getTabbedPane();
		if (gsTabbedPane.getSelectedIndex() != (iscompacteditor?1:0)) return;
		IDATPanel fstIdatPanel = (IDATPanel)gsTabbedPane.getSelectedComponent();
		GSHTMLEditorTextPane theTextPane = (GSHTMLEditorTextPane)e.getComponent();
		if (theTextPane != fstIdatPanel.getTextPane().getGSHTMLEditorTextPane()) return;
		int pos = theTextPane.getCaretPosition();
		
		char ch = getCharAt(theTextPane,pos);
		char chprev = getCharAt(theTextPane,pos-1);

		String ansString = "";
		int left = 0;
		boolean leftfound = false;	
		
		if (ch == '$'){
			left = pos;
			while (left > 0) {
				left--;
				ch = getCharAt(theTextPane,left);;
				if (! (('0' <= ch && ch <= '9') || ch == '$')) {
					break;
				} else if (ch == '$') {
					if (left == pos - 1) return;
					leftfound = true;
					break;
				}
			}
			if (!leftfound) return;
			try {
				ansString = theTextPane.getText(left,pos-left+1);
				if (ansString.charAt(0)=='$' && ansString.charAt(ansString.length()-1)=='$') {
					jumpToLine(new Integer(ansString.substring(1,ansString.length()-1)),window);
					if (iscompacteditor) window.getTabbedPane().setSelectedIndex(0);
				}
				return;
			} catch (BadLocationException e1) {
				return;
			}
		} else if (chprev == '$'){
			pos--;
			left = pos;
			while (left > 0) {
				left--;
				ch = getCharAt(theTextPane,left);;
				if (! (('0' <= ch && ch <= '9') || ch == '$')) {
					break;
				} else if (ch == '$') {
					if (left == pos - 1) return;
					leftfound = true;
					break;
				}
			}
			if (!leftfound) return;
			try {
				ansString = theTextPane.getText(left,pos-left+1);
				if (ansString.charAt(0)=='$' && ansString.charAt(ansString.length()-1)=='$') {
					int index = new Integer(ansString.substring(1,ansString.length()-1));
					jumpToLine(index,window);
					if (iscompacteditor) window.getTabbedPane().setSelectedIndex(0);
				}
				return;
			} catch (BadLocationException e1) {
				return;
			}
		}
	}


	private void jumpToLine(Integer n,AbstractGSWindow window) {
		SpreadCanvas canvas = window.getSpreadCanvas();
		LineSegment lineseg = canvas.imageLabel.getLineSeg(n);
		Region region = lineseg.transformToPolygonRegion(canvas.getSpread());
		region.setTemporary(true);
		region.setJumpedTo(true);
		canvas.addRegion(region);
		canvas.tmpPolyDeleteAndResetSelection(true);
		canvas.selectRegion(region);
		canvas.imageLabel.showImage();	
		canvas.imageLabel.moveToLine(lineseg.getCornerPoint());
	}
		
	private char getCharAt(GSHTMLEditorTextPane theTextPane, int pos) {
		try {
			return theTextPane.getText(pos,1).charAt(0);
		} catch (BadLocationException e) {
			return 0;
		}
	}
}