/* $Id: SquareView.java 363 2011-09-27 03:14:02Z shayashi $ */
package smart_gs.reasoning_web.swingui.view;

/*
 * Created on 2003/09/25
 *
 */

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.BasicStroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.Dimension;

/**
 * @author kazuaki kobayashi
 *
 */
public abstract class SquareView extends View{

	protected Rectangle2D rect;
	protected final int MARKER_SIZE=4;	/*Ĩ}[J[TCY*/
	protected boolean toBeFilled = false;
	
	
	public SquareView(){
		this.currentColor = Color.white;
		this.defaultColor = Color.white;
	}
	
	public void drawShape(Graphics2D g) {
		Color defaultColor=g.getColor();
		g.setColor(this.currentColor);
		g.fill(rect);
		if(this.isSelected){
			g.setColor(Color.RED);
		}else{
			g.setColor(Color.BLACK);
		}
		
		g.draw(rect);
   		if (toBeFilled) {
   			g.fill(rect);
   		}
		
		g.setColor(defaultColor);
	}

	public boolean contains(Point2D point) {
		return rect.contains(point);
	}

	public void moveBy(Point2D d) {
	    this.rect = new Rectangle2D.Double(rect.getX()+d.getX(),rect.getY()+d.getY(),rect.getWidth(),rect.getHeight());
	}
	
	public void fill() {
		toBeFilled = true;
	}
	
	public void unfill() {
		toBeFilled = false;
	}

	public abstract String toString();

	public void select(Graphics2D g){
		Rectangle2D bound=rect.getBounds2D();
		
		BasicStroke stroke=(BasicStroke)g.getStroke();
		
		/*_̍쐬*/
		float[] dashPhase={2,2};
		g.setStroke(new BasicStroke(stroke.getLineWidth(),
											stroke.getEndCap(),
											stroke.getLineJoin(),
											stroke.getMiterLimit(),
											dashPhase,
											0));

		g.draw(bound);
		g.setStroke(stroke);
		
		this.setMarker(g,new Point2D.Double( bound.getMinX()-MARKER_SIZE, bound.getMinY()-MARKER_SIZE));
		this.setMarker(g,new Point2D.Double( bound.getMaxX(), bound.getMinY()-MARKER_SIZE));
		this.setMarker(g,new Point2D.Double( bound.getMinX()- MARKER_SIZE,bound.getMaxY()));
		this.setMarker(g,new Point2D.Double( bound.getMaxX(), bound.getMaxY()));
	
	}
}
