package smart_gs.reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;

import reasoning_web.logical.Connection;
import reasoning_web.logical.inter_face.RWElement;

public class LinkRemover {

	public static void removeLinksOf(String url){
		if (url == null) return;
		ArrayList<Connection> deleteConnection = new ArrayList<Connection>();
		List<Connection> connectList = GS_RWRepository.getInstance().getConnections();
		for(int i=0;i<connectList.size();i++){
			Connection connection = connectList.get(i);
			RWElement sourceRWElement = connection.getSourcePointer().getRwElement();
			if(sourceRWElement instanceof GS_RWElement){
				String tmp = ((GS_RWElement)sourceRWElement).getURI();
				if(tmp != null && tmp.equals(url)){
					deleteConnection.add(connection);
					continue;
				}
			}
			RWElement targetRWElement = connection.getTargetPointer().getRwElement();
			if(targetRWElement instanceof GS_RWElement){
				if(((GS_RWElement)targetRWElement).getURI().equals(url)){
					deleteConnection.add(connection);
					continue;
				}
			}
		}
		if(deleteConnection.size() != 0){
			for(int i=0;i<deleteConnection.size();i++){
				Connection connection = deleteConnection.get(i);
				GS_RWRepository.getInstance().removeConnection(connection);
			}
		}

	}

}
