package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;

import smart_gs.debugprint.Debugprint;
import smart_gs.swingui.WorkspaceWindow;

import jp.ac.nii.hcp.shared.model.HCPProject;

public class ProjectExplorer extends JFrame {

	private static ProjectExplorer singleton = new ProjectExplorer();
	private ProjectExplorerMenuBar menuBar;
	private ProjectContentTreePanel mainPanel;
	private JPanel leftPanel;
	private ProjectList workspaceProjectList;
	private ProjectList repositoryProjectList;
	private ProjectListPanel workspaceProjectListPanel;
	private ProjectListPanel repositoryProjectListPanel;
	private ProjectContentPreviewPanel projectContentPreviewPanel;
	private HCPProject selectedProjectInWorkspace;
	private HCPProject selectedProjectInRepository;
	private int selectedRevision;
	
	private static final int WIDTH = 950;
	private static final int HEIGHT = 550;
	private static final Dimension max = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);

	public static ProjectExplorer getInstance() {
		return singleton;
	}

	public ProjectExplorer() {
		super("Project Explorer");
		Image icon = new ImageIcon("./icons/SGS_icon.gif").getImage();
		this.setIconImage(icon);
//		this.setLocationRelativeTo(null);
		
		this.menuBar = new ProjectExplorerMenuBar();
		this.setJMenuBar(this.menuBar);
		
		this.setMainPanel(new ProjectContentTreePanel());
		this.getMainPanel().setLayout(new BoxLayout(this.getMainPanel(), BoxLayout.PAGE_AXIS));
		this.getMainPanel().setPreferredSize(new Dimension(200,200));
		this.getMainPanel().setBackground(Color.WHITE);
		
		this.projectContentPreviewPanel = new ProjectContentPreviewPanel();
		
		this.workspaceProjectListPanel = new ProjectListPanel(Constants.WORKSPACE);
		this.workspaceProjectListPanel.setPreferredSize(max);
		this.workspaceProjectListPanel.setBorder(new TitledBorder("Workspace"));
		List<HCPProject> projects = ProjectHandler.getInstance().getProjectsFromWorkspace();
		this.addProjectList(projects, Constants.WORKSPACE);
	
		this.repositoryProjectListPanel = new ProjectListPanel(Constants.REPOSITORY);
		this.repositoryProjectListPanel.setPreferredSize(max);
		this.repositoryProjectListPanel.setBorder(new TitledBorder("Repository"));
		this.leftPanel = new JPanel();
		this.leftPanel.setLayout(new BoxLayout(this.leftPanel, BoxLayout.X_AXIS));
		this.leftPanel.add(this.workspaceProjectListPanel);
		this.leftPanel.add(this.repositoryProjectListPanel);

//		this.setDocumentContentPanel(new ProjectContentPreviewPanel());

		Container pane = this.getContentPane();
		JSplitPane vSplitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
				this.getMainPanel(), this.projectContentPreviewPanel);
		JSplitPane hSplitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
				this.leftPanel, vSplitPane);
		pane.add(hSplitPane, BorderLayout.CENTER);

		this.setSize(new Dimension(WIDTH, HEIGHT));
	}

	
	void addProjectList(List<HCPProject> projects, String location) {
		ProjectList list = new ProjectList(projects, location, true);
		JScrollPane sPane = new JScrollPane(list);
		sPane.setPreferredSize(max);
		if (location.equals(Constants.WORKSPACE)) {
			this.workspaceProjectListPanel.removeAll();
			this.workspaceProjectListPanel.setLayout(new BoxLayout(this.workspaceProjectListPanel, BoxLayout.PAGE_AXIS));
			this.workspaceProjectListPanel.add(new JScrollPane(list));
			this.workspaceProjectList = list;
		} else {
			this.repositoryProjectListPanel.removeAll();
			this.repositoryProjectListPanel.setLayout(new BoxLayout(this.repositoryProjectListPanel, BoxLayout.PAGE_AXIS));
			this.repositoryProjectListPanel.add(new JScrollPane(list));
			this.repositoryProjectList = list;
		}
		this.setVisible(true);
	}
	
	public void update() {
		List<HCPProject> projects1 = ProjectHandler.getInstance().getProjectsFromWorkspace();
		this.addProjectList(projects1, Constants.WORKSPACE);
		List<HCPProject> projects2;
		if (ProjectHandler.getInstance().authenticated()) {
			projects2 = ProjectHandler.getInstance().getProjectsFromRepository();
			this.addProjectList(projects2, Constants.REPOSITORY);
		}
		this.repaint();
		
	}

	public void browseSelectedProject(HCPProject project, String location) {
		this.getMainPanel().reset(project, location);
	}

	public void setSelectedProject(HCPProject project, String location) {
		if (location.equals(Constants.WORKSPACE)) {
			this.selectedProjectInWorkspace = project;
		} else {
			this.selectedProjectInRepository = project;
		}
		
	}

	public HCPProject getSelectecProject(String location) {
		if (location.equals(Constants.WORKSPACE)) {
			return this.selectedProjectInWorkspace;
		} else {
			return this.selectedProjectInRepository;
		}
		
	}

	
	public void setSelectedProjectInWorkspace(HCPProject project) {
		this.selectedProjectInWorkspace = project;
	}
	
	public HCPProject getSelectedProjectInWorkspace() {
		return selectedProjectInWorkspace;
	}

	public void setSelectedProjectInRepository(HCPProject project) {
		this.selectedProjectInRepository = project;
	}

	public HCPProject getSelectedProjectInRepository() {
		return selectedProjectInRepository;
	}

	public void setDocumentContentPanel(ProjectContentPreviewPanel documentContentPanel) {
		this.projectContentPreviewPanel = documentContentPanel;
	}

	public ProjectContentPreviewPanel getProjectContentPreviewPanel() {
		return projectContentPreviewPanel;
	}

	public int getSelectedRevision() {
		return this.selectedRevision;
	}
	public void setSelectedRevision(int revision) {
		this.selectedRevision = revision;
	}

	public void setMainPanel(ProjectContentTreePanel mainPanel) {
		this.mainPanel = mainPanel;
	}

	public ProjectContentTreePanel getMainPanel() {
		return mainPanel;
	}

	public ProjectTree getCurrentProjectTree() {
		return this.mainPanel.getProjectTree();
	}


	public ProjectList getProjectList(String location) {
		if (location.equals(Constants.WORKSPACE)) {
			return this.getWorkspaceProjectList();
		} else {
			return this.getRepositoryProjectList();
		}
	}

	public void setWorkspaceProjectList(ProjectList workspaceProjectList) {
		this.workspaceProjectList = workspaceProjectList;
	}

	public ProjectList getWorkspaceProjectList() {
		return workspaceProjectList;
	}

	public void setRepositoryProjectList(ProjectList repositoryProjectList) {
		this.repositoryProjectList = repositoryProjectList;
	}

	public ProjectList getRepositoryProjectList() {
		return repositoryProjectList;
	}

	public void setProjectContentPreviewPanel(ProjectContentPreviewPanel panel) {
		this.projectContentPreviewPanel = panel;
		
	}



}
