package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import jp.ac.nii.hcp.client.core.FileAttachmentManager;
import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPProject;
import smart_gs.debugprint.Debugprint;
import smart_gs.swingui.ButtonDialog;

public class AddAttachmentToProjectDialog extends ButtonDialog {

	private JTextField idField;
	private JTextField typeField;
	private JTextArea descriptionArea;
	private ProjectListPanel projectListPanel;
	List<HCPProject> projects;
	private File file;
	
	public AddAttachmentToProjectDialog(Frame parent, String title) {
		super(parent, title);
	}
	
	public AddAttachmentToProjectDialog(Frame parent, String title, File file) {
		this(parent, title);
		this.file = file;
		JPanel idPanel = new JPanel();
		idPanel.setBorder(new TitledBorder("Attachment File ID"));
		this.idField = new JTextField(22);
		this.idField.setText(file.getName());
		idPanel.add(this.idField);

		JPanel typePanel = new JPanel();
		typePanel.setBorder(new TitledBorder("Attachment File Type"));
		this.typeField = new JTextField(22);
		this.typeField.setText("");
		typePanel.add(this.typeField);

		this.descriptionArea = new JTextArea(3,22);
		this.descriptionArea.setText("");
		JScrollPane descriptionPane = new JScrollPane(this.descriptionArea);
		descriptionPane.setBorder(new TitledBorder("Description"));
		descriptionPane.setPreferredSize(new Dimension(220, 150));
		
		this.projects = ProjectHandler.getInstance().getProjectsFromWorkspace();
		this.projectListPanel = new ProjectListPanel(projects, Constants.WORKSPACE, false);

		JPanel nPanel = new JPanel();
		nPanel.setLayout(new BoxLayout(nPanel, BoxLayout.PAGE_AXIS));
		nPanel.add(idPanel);
		nPanel.add(typePanel);
		nPanel.add(descriptionPane);
		nPanel.add(this.projectListPanel);
		
		this.getContentPane().add(nPanel, BorderLayout.NORTH);
		this.setSize(new Dimension(250, 500));
		this.pack();
		
		this.getRootPane().setDefaultButton(this.okButton);
	}

	@Override
	public void ok() {
		String id = this.idField.getText();
		String type = null;
		if (!this.typeField.getText().equals("")) {
			type = this.typeField.getText();
		}
		String description = this.descriptionArea.getText();
		int index = this.projectListPanel.getProjectList().getSelectedIndex();
		if (index < 0) {
			JOptionPane.showMessageDialog(ProjectExplorer.getInstance(), "No project is selected.", "Error", JOptionPane.ERROR_MESSAGE);
		}
		HCPProject project = this.projects.get(index);
		try {
			FileAttachmentManager fam = ProjectHandler.getInstance().getAttachmentManager(project.name);
			try {
				Debugprint.from();
				Debugprint.message("id: " + id);
				Debugprint.message("file.getName(): " + this.file.getName());
				fam.addFileAttachment(id, file.getName(), type, description, this.file);
			} catch (IOException e) {
				new ShowResultDialog("Add Attachement", e).setVisible(true);
				e.printStackTrace();
			} catch (UnauthorizedException e) {
				new ShowResultDialog("Add Attachement", e).setVisible(true);
				e.printStackTrace();
			}
		} catch (HCPClientException e) {
			new ShowResultDialog("Add Attachement", e).setVisible(true);
			e.printStackTrace();
		}
		this.dispose();
	}

	@Override
	public void cancel() {
		this.dispose();		
	}

}
