/* $Id: FileMenu.java 716 2013-07-22 04:19:49Z minao $ */
package smart_gs.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import smart_gs.menu.action.ExitActionListener;
import smart_gs.menu.action.ExportProjectAsGSXActionListener;
import smart_gs.menu.action.ImportGSFileListner;
import smart_gs.menu.action.NewFileActionListener;
import smart_gs.menu.action.OpenOldVersionActionListener;
import smart_gs.menu.action.ShowVersionAction;
import smart_gs.network.ConvertGsxFileToHCPProjectActionListener;
import smart_gs.network.ProjectExplorer;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.OpenActionListener;
import smart_gs.swingui.toolbar.action.SaveActionListener;
import smart_gs.swingui.toolbar.action.TextExportActionListener;
import smart_gs.swingui.toolbar.action.WebDavSyncActionListener;
@SuppressWarnings("serial")

public class FileMenu extends JMenu{
	
	public FileMenu(String title) {
		super(title);
		JMenuItem newFile = new JMenuItem("New");
		newFile.addActionListener(new NewFileActionListener());
		this.add(newFile);

		//2007/11/1 kazuhiro kobayashi
		JMenuItem openFile = new JMenuItem("Open GSX File");
		openFile.addActionListener(new OpenActionListener(0));
		openFile.setAccelerator(KeyStroke.getKeyStroke("ctrl O"));
		this.add(openFile);
		
		JMenuItem openProject = new JMenuItem("Open HCP Project");
		openProject.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				JList projectList = ProjectExplorer.getInstance().getProjectList(smart_gs.network.Constants.WORKSPACE);
				JList newProjectList = new JList();
				DefaultListModel model = new DefaultListModel();
				for (int i = 0; i < projectList.getModel().getSize(); i++) {
					model.addElement(projectList.getModel().getElementAt(i));
				}
				newProjectList.setModel(model);
				new smart_gs.network.SelectProjectFrame(WorkspaceWindow.getInstance(), newProjectList, smart_gs.network.Constants.OPEN).setVisible(true);				
			}
		});
		openProject.setAccelerator(KeyStroke.getKeyStroke("ctrl P"));
		this.add(openProject);

		JMenuItem gsxToProject = new JMenuItem("Convert GSX File to HCP Project and Open");
		gsxToProject.addActionListener(new ConvertGsxFileToHCPProjectActionListener());
		this.add(gsxToProject);
		
		//2011/06/06 kukita
		JMenuItem openOldVersion = new JMenuItem("Convert GS File to GSX File and Open");
		openOldVersion.addActionListener(new OpenOldVersionActionListener(0));
		this.add(openOldVersion);

		JMenuItem saveAS = new JMenuItem("Save as ...");
		saveAS.addActionListener(new SaveActionListener(0));
		saveAS.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
		this.add(saveAS);

		JMenuItem save = new JMenuItem("Save");
		save.addActionListener(new SaveActionListener(2));
//		save.setAccelerator();
		this.add(save);

//		20110328 shayashi
		JMenuItem importGSfile = new JMenuItem("Import");
		importGSfile.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
		importGSfile.addActionListener(new ImportGSFileListner(0));
		this.add(importGSfile);
		importGSfile.setEnabled(false);

		JMenuItem export = new JMenuItem("Export");
		export.addActionListener(new TextExportActionListener());
		export.setAccelerator(KeyStroke.getKeyStroke("ctrl E"));
		this.add(export);
//		export.setEnabled(false);

		JMenuItem exportProjectAsGSX = new JMenuItem("Export Project as GSX");
		exportProjectAsGSX.addActionListener(new ExportProjectAsGSXActionListener());
		this.add(exportProjectAsGSX);

		this.addSeparator();
		JMenuItem openwebdav = new JMenuItem("Open from WebDAV");
		openwebdav.addActionListener(new OpenActionListener(1));
		openwebdav.setAccelerator(KeyStroke.getKeyStroke("ctrl G"));
		this.add(openwebdav);

		JMenuItem savewebdav = new JMenuItem("Save to WebDAV");
		savewebdav.addActionListener(new SaveActionListener(1));
		savewebdav.setAccelerator(KeyStroke.getKeyStroke("ctrl H"));
		this.add(savewebdav);

		this.addSeparator();
		JMenuItem syncwebdav = new JMenuItem("Synchronize with WebDAV");
		syncwebdav.addActionListener(new WebDavSyncActionListener());
		syncwebdav.setAccelerator(KeyStroke.getKeyStroke("ctrl J"));
		this.add(syncwebdav);

		this.addSeparator();
		
		JMenuItem exit = new JMenuItem("Exit");
		exit.addActionListener(new ExitActionListener());
		exit.setAccelerator(KeyStroke.getKeyStroke("ctrl W"));
		this.add(exit);
		
		
		JMenuItem forVersion = new JMenuItem("Version");
	    forVersion.addActionListener(new ShowVersionAction());
		this.add(forVersion);
	}
}
