package smart_gs.image_search.normal.swingui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import sml_editor.logical.LineDirection;

//public class AbstractTranscriptionPanel extends JPanel {
//
//	public AbstractTranscriptionPanel(TranscriptionFrame transcriptionFrame,
//			List<SearchResult> results, Image queryImage) {
//		// TODO Auto-generated constructor stub
//	}


public abstract class AbstractTranscriptionPanel extends JPanel {	
	protected List<SearchResult> results;

	protected List<JPanel> previousResults;
	protected List<JPanel> nextResults;
	protected List<JPanel> currentResults;

	protected int SIZE_TO_DISPLAY = 20;	
	protected int count = 0;
	protected int nextCount;
	protected boolean isFirst = true;

	protected Thread nextThread = null;

	protected TranscriptionToolNo1Frame parent;

	protected Image queryImage;
	
	private LineDirection lineDirection;

	public AbstractTranscriptionPanel(TranscriptionToolNo1Frame parent,List<SearchResult> results, Image queryImage, LineDirection lineDirection){
		this.parent = parent;
		this.results = results;
		this.previousResults = new ArrayList<JPanel>();
		this.nextResults = new ArrayList<JPanel>();
		this.currentResults = new ArrayList<JPanel>();
		this.queryImage = queryImage;
		this.lineDirection = lineDirection;
	}

	public void showResult(List<JPanel> list){
		this.removeAll();

		if(nextThread.isAlive()){
			try {
				nextThread.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}

		for(int i=0;i<list.size();i++){
			this.add(list.get(i));
		}
		this.currentResults.clear();
		this.currentResults.addAll(this.nextResults);
	}
	public void next(){
		this.count++;
		this.nextCount = this.count+1;
		this.showResult(this.nextResults);
		this.createNextResults(nextCount,this.lineDirection);
	}
	public void back(){
		this.count--;
		this.nextCount = this.count+1;
		if(nextThread.isAlive()){
			nextThread.interrupt();
		}
		this.createNextResults(count,this.lineDirection);
		this.showResult(this.nextResults);
		this.createNextResults(nextCount,this.lineDirection);
	}

	public synchronized void createNextResults(final int count, final LineDirection lineDirection){
		final int text_type = Preference.getInstance().getTextType();
		nextThread = new Thread(){
			@Override
			public void run() {
				super.run();

				int beginIndex = count*SIZE_TO_DISPLAY;
				nextResults.clear();
				for(int i=beginIndex;i<beginIndex+SIZE_TO_DISPLAY && i<results.size();i++){
					JPanel labelPanel = new JPanel();
					JPanel checkBoxPanel;
					if (lineDirection== LineDirection.HORIZONTAL) {
						checkBoxPanel = new JPanel(new GridLayout(2,1));
					} else {
						checkBoxPanel = new JPanel(new GridLayout(3,1));
					}

					ButtonGroup g = new ButtonGroup();
					JCheckBox checkBox = new JCheckBox("Yes");
					JCheckBox removeBox = new JCheckBox("No");

					g.add(checkBox);
					g.add(removeBox);



					JLabel newLabel = new JLabel("");
					if(results.get(i).isInBucket()){
						newLabel.setIcon(new ImageIcon("./icons/copy.gif"));
					}else if(!results.get(i).wasShown()){
						newLabel.setIcon(new ImageIcon("./icons/new.gif"));
					}
					checkBox.addItemListener(new CheckActionForTranscription(parent,results.get(i)));
					removeBox.addItemListener(new RemoveActionForTranscription(parent,results.get(i)));

					checkBoxPanel.add(newLabel);
					checkBoxPanel.add(checkBox);
					checkBoxPanel.add(removeBox);

					JLabel label = createImageLabel(results.get(i), queryImage);	
					Spread spread = results.get(i).getSpread();

//					HERE HERE. Experiment this:
//					default is horizontal. is this ok? vertical is better?
//					horizontal in vertical mode, or vertical in horizontal mode?
					if (spread.getLineDirection() == LineDirection.HORIZONTAL) {
						labelPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
						labelPanel.add(checkBoxPanel);


						labelPanel.setBorder(new LineBorder(Color.BLACK));

						labelPanel.add(label);					
						nextResults.add(labelPanel);
					} else {
						labelPanel.setLayout(new BoxLayout(labelPanel,BoxLayout.Y_AXIS));
						labelPanel.add(checkBoxPanel);

						labelPanel.setBorder(new LineBorder(Color.BLACK));
						labelPanel.add(label);	
						nextResults.add(labelPanel);
					}
					spread.release();
				}
			}
		};
		nextThread.start();
	}
	// 20110423 shayashi queryImage is used for correction of resulting image size.
	protected abstract JLabel createImageLabel(SearchResult result, Image queryImage);

	public void updateBucket() {
		int beginIndex = count*SIZE_TO_DISPLAY;

		for (int i = 0; i < SIZE_TO_DISPLAY - 1; i++) {
			JPanel panel = this.currentResults.get(i);
			JLabel label = (JLabel)((JPanel)panel.getComponent(0)).getComponent(0);
			if(this.results.get(beginIndex+i).isInBucket()){
				label.setIcon(new ImageIcon("./icons/copy.gif"));
			}
		}
		this.parent.validate();
		this.repaint();
		this.validate();
	}
}







