/* $Id: LineSegEditorDrawMode.java 626 2013-01-13 18:51:36Z shayashi $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.LineSegEditorCanvas;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.GSMouseEvent;

public class LineSegEditorDrawMode implements LineSegEditorMode{
	
	private static LineSegEditorDrawMode singleton = new LineSegEditorDrawMode();
	
	private Point2D start;
	private Point2D end;

	private List<Point2D> points;
	
	private Point2D tempStart;
	private Point2D tempEnd;
	private List<Point2D> tempPoints;
	private List<ExLine2D> lines;
	private LineSegEditor editor;
	
	/**
	 * @return the editor
	 */
	public LineSegEditor getEditor() {
		return editor;
	}
	/**
	 * @param editor the editor to set
	 */
	public void setEditor(LineSegEditor editor) {
		this.editor = editor;
	}
	private LineSegEditorDrawMode() {
		this.lines = new ArrayList<ExLine2D>();
		this.points = new ArrayList<Point2D>();
		this.tempPoints = new ArrayList<Point2D>();
	}
	public static LineSegEditorDrawMode getInstance(){
		return singleton;
	}

	public void mousePressed(GSMouseEvent e, LineSegEditorCanvas canvas) {
		setCursor(canvas);
		if (e.getButton() != MouseEvent.BUTTON1) {
			this.cancel();
			return;
		}
		if(this.start == null){
			this.start = e.getPoint();
			this.tempStart = e.getOriginalPoint();
			this.points.add(this.start);
			this.tempPoints.add(this.tempStart);
			return;
		}
		this.end = e.getPoint();
		this.tempEnd = e.getOriginalPoint();
		
		this.lines.add(new ExLine2D(start,end));
//		this.lines.add(new ExLine2D(tempStart,tempEnd));
		this.points.add(this.end);
		this.tempPoints.add(this.tempEnd);
		this.start = this.end;
		this.tempStart = this.tempEnd;
	}
	
	public void mouseClicked(GSMouseEvent e,LineSegEditorCanvas canvas) {
		if (e.getButton() != MouseEvent.BUTTON1) {
			this.cancel();
			return;
		}
		setCursor(canvas);
		
		if(e.getClickCount() == 2){
			int nextIndex = canvas.getLines().size();
			editor.pushLinestack();
			canvas.addLineSegmentForEdit(new LineSegmentForEdit(this.points, this.editor.getSpread().getLineDirection(), nextIndex));

			this.lines = new ArrayList<ExLine2D>();
			this.points = new ArrayList<Point2D>();
			this.tempPoints = new ArrayList<Point2D>();
			this.start = null;
			this.end = null;
			this.tempStart = null;
			this.tempEnd = null;
			return;
		}
	}
	
	public void mouseMoved(GSMouseEvent e,LineSegEditorCanvas canvas) {
		setCursor(canvas);
		this.end = e.getPoint();
		this.tempEnd = e.getOriginalPoint();
		setCursor(canvas);
	}

	@Override
	public void paint(Graphics g,LineSegEditorCanvas canvas) {	
		if(this.start == null || this.end == null){
			return ;
		}
		double ratio = canvas.getLineSegEditorImageLabel().getRatio();
		double gapX = canvas.getLineSegEditorImageLabel().getGapWidth();
		double gapY = canvas.getLineSegEditorImageLabel().getGapHeight();
		for(int i=0;i<this.lines.size();i++){
			ExLine2D line = this.lines.get(i);
			new LineView(line).enlargedView(ratio,gapX,gapY).draw((Graphics2D)g);
		}

		new LineView(new ExLine2D(start,end)).enlargedView(ratio,gapX,gapY).draw((Graphics2D)g);

		setCursor(canvas);
	}
	
	public void cancel() {
		// TODO Auto-generated method stub
		
	}
	
	public void mouseDragged(GSMouseEvent e, LineSegEditorCanvas canvas) {
		setCursor(canvas);		
	}
	
	public void mouseEntered(GSMouseEvent e, LineSegEditorCanvas canvas) {
		setCursor(canvas);		
	}
	
	public void mouseExited(GSMouseEvent e, LineSegEditorCanvas canvas) {
		setCursor(canvas);
		
	}
	
	public void mouseReleased(GSMouseEvent e, LineSegEditorCanvas canvas) {
		setCursor(canvas);		
	}
	
	public void setCursor(LineSegEditorCanvas canvas) {
		canvas.getLineSegEditorImageLabel().setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));		
	}

}
