/* $Id: PreferenceMenu.java 651 2013-02-08 01:10:55Z ohura $ */
package smart_gs.menu;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.Preference;
import smart_gs.menu.action.BookmarkChangeDefaultColorAction;
import smart_gs.menu.action.BookmarkChangeDefaultSizeAction;
import smart_gs.menu.action.ChangeTextTypeAction;
import smart_gs.menu.action.ChangeUserNameAction;
import smart_gs.menu.action.MarkerChangeDefaultBreadthAction;
import smart_gs.menu.action.MarkerChangeDefaultColorAction;
import smart_gs.menu.action.MemoPadChangeDefaultColorAction;
import smart_gs.menu.action.RectangleMoveAction;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import webdav.preference.ProxySetting;
import webdav.preference.WebDavSetting;

public class PreferenceMenu extends JMenu {

	public PreferenceMenu(String title, AbstractGSWindow window) {
		super(title);

		JMenuItem userName = new JMenuItem("User Name");
		userName.addActionListener(new ChangeUserNameAction());
		this.add(userName);

//		JMenuItem locale = new JMenuItem("Location: " + Preference.getInstance().getLocale());
//		locale.addActionListener(new ChangeLocaleAction());
//		this.add(locale);

		JMenuItem IDATNamesSetting = new JMenuItem("IDAT Names");
		IDATNamesSetting.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				IDATNamesSetting iDATNamesSetting = new IDATNamesSetting(WorkspaceWindow.getInstance(),true);
				iDATNamesSetting.setLocationRelativeTo(null);
				iDATNamesSetting.setVisible(true);
			}
		});
		this.add(IDATNamesSetting);

		JMenu imageSearchEngine = new JMenu("Image Search Engine");
		boolean isExternalEngine = GSSearchEngine.getInstance().isUseExternalEngine();
		JMenuItem externalEngine = new JRadioButtonMenuItem("External",isExternalEngine);
		externalEngine.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				GSSearchEngine.getInstance().setUseExternalEngine(true);
			}
		});
		
		JMenuItem internalEngine = new JRadioButtonMenuItem("Internal",isExternalEngine==false);
		internalEngine.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				GSSearchEngine.getInstance().setUseExternalEngine(false);
			}
		});
		ButtonGroup imageSearchEngineGroup = new ButtonGroup();
		imageSearchEngineGroup.add(externalEngine);
		imageSearchEngineGroup.add(internalEngine);
		imageSearchEngine.add(externalEngine);
		imageSearchEngine.add(internalEngine);

		this.add(imageSearchEngine);
		
		
		
		//20090909 North Grid Add
		JMenu imageSearchType = new JMenu("Image Search Type in Dictionary");
		String type = Preference.getInstance().getSearchImageDictionaryLogic();
		boolean isType1 = false;
		boolean isType2 = false;
		boolean isType3 = false;
		if(type.equals("0")){
			isType1 = true;
		}else if(type.equals("1")){
			isType2 = true;
		}else if(type.equals("2")){
			isType3 = true;
		}else {
			isType1 = true;
		}
		JMenuItem type1 = new JRadioButtonMenuItem("Type1",isType1);
		type1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().setSearchImageDictionaryLogic("0");
			}
		});
		JMenuItem type2 = new JRadioButtonMenuItem("Type2",isType2);
		type2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().setSearchImageDictionaryLogic("1");
			}
		});
		JMenuItem type3 = new JRadioButtonMenuItem("Type3",isType3);
		type3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().setSearchImageDictionaryLogic("2");
			}
		});
		ButtonGroup imageSearchTypeGroup = new ButtonGroup();
		imageSearchTypeGroup.add(type1);
		imageSearchTypeGroup.add(type2);
		imageSearchTypeGroup.add(type3);

		imageSearchType.add(type1);
		imageSearchType.add(type2);
		imageSearchType.add(type3);

		this.add(imageSearchType);
		
		JMenu textType = new JMenu("Text Type");
		JMenuItem horizontal = new JRadioButtonMenuItem("Horizontal",TextType.isHorizontal());
		horizontal.addActionListener(new ChangeTextTypeAction(
				TextType.HORIZONTAL));
		JMenuItem vertical = new JRadioButtonMenuItem("Vertical",TextType.isHorizontal()==false);
		vertical.addActionListener(new ChangeTextTypeAction(
				TextType.VERTICAL));
		ButtonGroup textTypeGroup = new ButtonGroup();
		textTypeGroup.add(horizontal);
		textTypeGroup.add(vertical);
		textType.add(horizontal);
		textType.add(vertical);
		
		this.add(textType);
		

		JMenuItem maxSearchNum = new JMenuItem("Search Size Bound");
		this.add(maxSearchNum);
		maxSearchNum.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String sizeStr = JOptionPane
						.showInputDialog("Input Max Found Size");
				if (sizeStr == null) {
					return;
				}
				try {
					int size = Integer.parseInt(sizeStr);
					GSSearchEngine.getInstance().setMaxFound(size);
				} catch (NumberFormatException nfe) {
					nfe.printStackTrace();
				}
			}
		});

		JMenu markupMenu = new JMenu("Markup"); // 2010/12/01 kukita altered the name of this menu item
		JMenu markupMove = new JMenu("Movability"); // 2010/12/01 kukita
		boolean markupMovability = UniSelectedState.getInstance().getMarkupMovability();
		JMenuItem move = new JRadioButtonMenuItem("Movable",markupMovability);
		JMenuItem notMove = new JRadioButtonMenuItem("UnMovable",!markupMovability);
		ButtonGroup recGroup = new ButtonGroup();
		recGroup.add(move);
		recGroup.add(notMove);
		markupMove.add(move);
		markupMove.add(notMove);
		markupMenu.add(markupMove); // 2010/12/01 kukita
		move.addActionListener(new RectangleMoveAction(true));
		notMove.addActionListener(new RectangleMoveAction(false));
		this.add(markupMenu);// 2010/12/01 kukita

		// 2010/11/30 kukita
		JMenu memoPadDefaultColor = new JMenu("MemoPad Default Color");
		Color memoPad_dc = MemoPadView.stringToColor(Preference.getInstance().getMemoPadColor());
		JMenuItem memoPad_yellow = 
			new JRadioButtonMenuItem("Yellow",memoPad_dc == MemoPadView.MEMOPAD_YELLOW);
		JMenuItem memoPad_cyan = 
			new JRadioButtonMenuItem("Cyan",memoPad_dc == MemoPadView.MEMOPAD_CYAN);
		JMenuItem memoPad_magenta = 
			new JRadioButtonMenuItem("Magenta",memoPad_dc == MemoPadView.MEMOPAD_MAGENTA);
		JMenuItem memoPad_green = 
			new JRadioButtonMenuItem("Green",memoPad_dc == MemoPadView.MEMOPAD_GREEN);
		ButtonGroup memoPadColorGroup = new ButtonGroup();
		memoPadColorGroup.add(memoPad_yellow);
		memoPadColorGroup.add(memoPad_cyan);
		memoPadColorGroup.add(memoPad_magenta);
		memoPadColorGroup.add(memoPad_green);
		memoPadDefaultColor.add(memoPad_yellow);
		memoPadDefaultColor.add(memoPad_cyan);
		memoPadDefaultColor.add(memoPad_magenta);
		memoPadDefaultColor.add(memoPad_green);
		memoPad_yellow.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MEMOPAD_YELLOW));
		memoPad_cyan.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MEMOPAD_CYAN));
		memoPad_magenta.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MEMOPAD_MAGENTA));
		memoPad_green.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MEMOPAD_GREEN));
		markupMenu.add(memoPadDefaultColor);// 2010/12/01 kukita
		
		JMenu markerDefaultColor = new JMenu("Marker Default Color");
		Color marker_dc = MarkerView.stringToColor(Preference.getInstance().getMarkerColor());
		JMenuItem marker_yellow = 
			new JRadioButtonMenuItem("Yellow",marker_dc == MarkerView.MARKER_YELLOW);
		JMenuItem marker_cyan = 
			new JRadioButtonMenuItem("Cyan",marker_dc == MarkerView.MARKER_CYAN);
		JMenuItem marker_magenta = 
			new JRadioButtonMenuItem("Magenta",marker_dc == MarkerView.MARKER_MAGENTA);
		JMenuItem marker_green = 
			new JRadioButtonMenuItem("Green",marker_dc == MarkerView.MARKER_GREEN);
		ButtonGroup markerColorGroup = new ButtonGroup();
		markerColorGroup.add(marker_yellow);
		markerColorGroup.add(marker_cyan);
		markerColorGroup.add(marker_magenta);
		markerColorGroup.add(marker_green);
		markerDefaultColor.add(marker_yellow);
		markerDefaultColor.add(marker_cyan);
		markerDefaultColor.add(marker_magenta);
		markerDefaultColor.add(marker_green);
		marker_yellow.addActionListener(new MarkerChangeDefaultColorAction(MarkerView.MARKER_YELLOW));
		marker_cyan.addActionListener(new MarkerChangeDefaultColorAction(MarkerView.MARKER_CYAN));
		marker_magenta.addActionListener(new MarkerChangeDefaultColorAction(MarkerView.MARKER_MAGENTA));
		marker_green.addActionListener(new MarkerChangeDefaultColorAction(MarkerView.MARKER_GREEN));
		markupMenu.add(markerDefaultColor);// 2010/12/01 kukita
		
		JMenuItem markerDefaultBreadth = new JMenuItem("Marker Default Breadth");
		markerDefaultBreadth.addActionListener(new MarkerChangeDefaultBreadthAction(window));
		markupMenu.add(markerDefaultBreadth);
		
		JMenu bookmarkDefaultColor = new JMenu("Bookmark Default Color");
		String currentColor = Preference.getInstance().getDefaultBookmarkPath();
		JMenuItem  bookmarkRed = new JRadioButtonMenuItem("Red", currentColor == BookmarkView.PATH_TO_RED);
		JMenuItem bookmarkBlue = new JRadioButtonMenuItem("Blue", currentColor == BookmarkView.PATH_TO_BLUE);
		JMenuItem bookmarkPurple = new JRadioButtonMenuItem("Purple", currentColor == BookmarkView.PATH_TO_PURPLE);;
		JMenuItem bookmarkGray = new JRadioButtonMenuItem("Gray", currentColor == BookmarkView.PATH_TO_GRAY);;
		JMenuItem bookmarkGreen = new JRadioButtonMenuItem("Green", currentColor == BookmarkView.PATH_TO_GREEN);
		ButtonGroup bookmarkColorGroup = new ButtonGroup();
		bookmarkColorGroup.add(bookmarkRed);
		bookmarkColorGroup.add(bookmarkBlue);
		bookmarkColorGroup.add(bookmarkPurple);
		bookmarkColorGroup.add(bookmarkGray);
		bookmarkColorGroup.add(bookmarkGreen);
		bookmarkDefaultColor.add(bookmarkRed);
		bookmarkDefaultColor.add(bookmarkBlue);
		bookmarkDefaultColor.add(bookmarkPurple);
		bookmarkDefaultColor.add(bookmarkGray);
		bookmarkDefaultColor.add(bookmarkGreen);
		bookmarkRed.addActionListener(new BookmarkChangeDefaultColorAction(BookmarkView.PATH_TO_RED));
		bookmarkBlue.addActionListener(new BookmarkChangeDefaultColorAction(BookmarkView.PATH_TO_BLUE));
		bookmarkPurple.addActionListener(new BookmarkChangeDefaultColorAction(BookmarkView.PATH_TO_PURPLE));
		bookmarkGray.addActionListener(new BookmarkChangeDefaultColorAction(BookmarkView.PATH_TO_GRAY));
		bookmarkGreen.addActionListener(new BookmarkChangeDefaultColorAction(BookmarkView.PATH_TO_GREEN));
		
		markupMenu.add(bookmarkDefaultColor);
		

		JMenu bookmarkDefaultSize = new JMenu("Bookmark Default Size");
		double ds = new Double(Preference.getInstance().getBookmarkSize());
		JMenuItem  huge = new JRadioButtonMenuItem((int)(100 * BookmarkView.HUGE) + "%", ds == BookmarkView.HUGE);
		JMenuItem large = new JRadioButtonMenuItem((int)(100 * BookmarkView.LARGE) + "%", ds == BookmarkView.LARGE);
		JMenuItem normal = new JRadioButtonMenuItem((int)(100 * BookmarkView.NORMAL) + "%", ds == BookmarkView.NORMAL);
		JMenuItem small = new JRadioButtonMenuItem((int)(100 * BookmarkView.SMALL) + "%", ds == BookmarkView.SMALL);
		JMenuItem tiny = new JRadioButtonMenuItem((int)(100 * BookmarkView.TINY) + "%", ds == BookmarkView.TINY);
		ButtonGroup bookmarkSizeGroup = new ButtonGroup();
		bookmarkSizeGroup.add(huge);
		bookmarkSizeGroup.add(large);
		bookmarkSizeGroup.add(normal);
		bookmarkSizeGroup.add(small);
		bookmarkSizeGroup.add(tiny);
		bookmarkDefaultSize.add(huge);
		bookmarkDefaultSize.add(large);
		bookmarkDefaultSize.add(normal);
		bookmarkDefaultSize.add(small);
		bookmarkDefaultSize.add(tiny);
		huge.addActionListener(new BookmarkChangeDefaultSizeAction(BookmarkView.HUGE));
		large.addActionListener(new BookmarkChangeDefaultSizeAction(BookmarkView.LARGE));
		normal.addActionListener(new BookmarkChangeDefaultSizeAction(BookmarkView.NORMAL));
		small.addActionListener(new BookmarkChangeDefaultSizeAction(BookmarkView.SMALL));
		tiny.addActionListener(new BookmarkChangeDefaultSizeAction(BookmarkView.TINY));

		
		markupMenu.add(bookmarkDefaultSize);

		JMenu resourceBasketDefaultSaveOption = new JMenu("Resource Basket Default Save Option");

		boolean dcbv = new Boolean(Preference.getInstance().getResourceBasketSaveOption());
		JMenuItem saveBasket = new JRadioButtonMenuItem("Save", dcbv);
		saveBasket.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().setResourceBasketSaveOption("true");
			}
		});
		JMenuItem deleteBasket = new JRadioButtonMenuItem("Do not save", !dcbv);
		saveBasket.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().setResourceBasketSaveOption("false");
			}
		});
		ButtonGroup basketDefaultSaveOptionGroup = new ButtonGroup();
		basketDefaultSaveOptionGroup.add(saveBasket);
		basketDefaultSaveOptionGroup.add(deleteBasket);
		resourceBasketDefaultSaveOption.add(saveBasket);
		resourceBasketDefaultSaveOption.add(deleteBasket);
		this.add(resourceBasketDefaultSaveOption);
	
		
		JMenuItem setDirectoryPath = new JMenuItem("Data Directories & Files");
		setDirectoryPath.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				DirectorySettingWindow.getInstance().setVisible(true);
			}
		});
		this.add(setDirectoryPath);
		
		// ADD NorthGrid 2009/01/31
		JMenuItem setWebDavSetting = new JMenuItem("WebDAV");
		setWebDavSetting.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				WebDavSetting webDavSetting = new WebDavSetting(WorkspaceWindow.getInstance(),true);
				webDavSetting.setLocationRelativeTo(null);
				webDavSetting.setVisible(true);
			}
		});
		this.add(setWebDavSetting);

		// ADD NorthGrid 2010/04/19
		JMenuItem setProxySetting = new JMenuItem("Proxy");
		setProxySetting.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				ProxySetting proxySetting = new ProxySetting(WorkspaceWindow.getInstance(),true);
				proxySetting.setLocationRelativeTo(null);
				proxySetting.setVisible(true);
			}
		});
		this.add(setProxySetting);

		// ADD NorthGrid 2009/02/22
		JMenuItem setWebBrowser = new JMenuItem("Web Browser");
		setWebBrowser.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				BrowserSettingDialog browserSettingDialog = new BrowserSettingDialog(WorkspaceWindow.getInstance());
				browserSettingDialog.setLocationRelativeTo(null);
				browserSettingDialog.setVisible(true);
			}
		});
		this.add(setWebBrowser);
		
		
		// ADD NorthGrid 2009/02/22
		JMenuItem setExternalEditor = new JMenuItem("External Editor");
		setExternalEditor.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				ExternalEditorSettingDialog externalEditorSettingDialog = new ExternalEditorSettingDialog(WorkspaceWindow.getInstance());
				externalEditorSettingDialog.setLocationRelativeTo(null);
				externalEditorSettingDialog.setVisible(true);
			}
		});
		this.add(setExternalEditor);
		
		JMenu windowDisplayMode = new JMenu("Window Display Mode: image is at ");
		
		
		JMenuItem textTop = new JRadioButtonMenuItem("Top",Preference.windowModeIsTop());
		textTop.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.setWindowModeToTop();
				WorkspaceWindow.getInstance().displayWorksapceWindow(0);
			}
		});
		
		JMenuItem textBottom = new JRadioButtonMenuItem("Bottom",Preference.windowModeIsBottom());
		textBottom.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.setWindowModeToBottom();
				WorkspaceWindow.getInstance().displayWorksapceWindow(1);
			}
		});
		
		JMenuItem textLeft = new JRadioButtonMenuItem("Left",Preference.windowModeIsLeft());
		textLeft.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.setWindowModeToLeft();
				WorkspaceWindow.getInstance().displayWorksapceWindow(2);
			}
		});
		
		JMenuItem textRight = new JRadioButtonMenuItem("Right",Preference.windowModeIsRight());
		textRight.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.setWindowModeToRight();
				WorkspaceWindow.getInstance().displayWorksapceWindow(GSConstants.WINDOW_HORIZONTAL_IMAGE_RIGHT_MODE);
			}
		});
		
		ButtonGroup windowDisplayModeGroup = new ButtonGroup();
		windowDisplayModeGroup.add(textTop);
		windowDisplayModeGroup.add(textBottom);
		windowDisplayModeGroup.add(textLeft);
		windowDisplayModeGroup.add(textRight);
		windowDisplayMode.add(textTop);
		windowDisplayMode.add(textBottom);
		windowDisplayMode.add(textLeft);
		windowDisplayMode.add(textRight);

		this.add(windowDisplayMode);
		
		boolean defaultSearchHighlightMode = new Boolean(Preference.getInstance().getSearchHighlightMode());
		JMenu searchHighlightMode = new JMenu("Search Highlight Mode");
		JMenuItem highlightAll = new JRadioButtonMenuItem("All",defaultSearchHighlightMode);
		highlightAll.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().setSearchHighlightMode("true");
			}
		});
		JMenuItem highlightOff = new JRadioButtonMenuItem("Off",!defaultSearchHighlightMode);
		highlightOff.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().setSearchHighlightMode("false");
			}
		});
		ButtonGroup searchHighlightModeGroup = new ButtonGroup();
		searchHighlightModeGroup.add(highlightAll);
		searchHighlightModeGroup.add(highlightOff);
		searchHighlightMode.add(highlightAll);
		searchHighlightMode.add(highlightOff);
		this.add(searchHighlightMode);
		
//		int defaultGSEditorType = Preference.getInstance().getEditorType();
//
//		JMenu defaultGSEditorTypeMenu = new JMenu("Editor Type");
//		JMenuItem full = new JRadioButtonMenuItem("Full",defaultGSEditorType == GSEditor.FULL);
//		full.addActionListener(new ActionListener() {
//			public void actionPerformed(ActionEvent e) {
//				Preference.getInstance().setEditorTypeFull();
//			}
//		});
//		JMenuItem compact = new JRadioButtonMenuItem("Compact",defaultGSEditorType == GSEditor.COMPACT);
//		compact.addActionListener(new ActionListener() {
//			public void actionPerformed(ActionEvent e) {
//				Preference.getInstance().setEditorTypeCompact();
//			}
//		});
//		ButtonGroup editorType = new ButtonGroup();
//		editorType.add(full);
//		editorType.add(compact);
//		
//		defaultGSEditorTypeMenu.add(full);
//		defaultGSEditorTypeMenu.add(compact);
//		
//		this.add(defaultGSEditorTypeMenu);
		
		// 2011/11/16 kukita
		this.addSeparator();
		
		JMenuItem reset = new JMenuItem("Reset to Default");
		reset.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				Preference.reset();
			}
		});
		this.add(reset);
		
		
	}
}
