/* $Id: XML2RWElementConverter.java 391 2011-10-10 15:17:20Z minao $ */
package smart_gs.reasoning_web.logical;

import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import javax.imageio.ImageIO;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBucket;
import smart_gs.logical.GSResource;
import smart_gs.logical.Spread;
import smart_gs.logical.StandardTextDocument;
import smart_gs.logical.URICreator;
import smart_gs.logical.URISolver;
import smart_gs.logical.XML2ResourceConverter;
import smart_gs.reasoning_web.desktop.logical.ShortCut;

public class XML2RWElementConverter {
	
	public static GS_RWElement convert(Element element){

		String tagname = element.getNodeName();
		if(tagname.equals("standardDocument")){
			return getStandardDocument(element);
		}else if(tagname.equals(URICreator.RWPACKAGE)){
			return getPackage(element);
		}else if(tagname.equals(URICreator.GSQUERY)){
			return getQuery(element);
		}else if(tagname.equals(URICreator.SHORTCUT)){
			return getShortCut(element);
		}else if(tagname.equals(URICreator.BUCKET) || tagname.equals("backet")){
			return QueryBucket.restore(element);
		}
		else{
			return XML2ResourceConverter.convert(element);
		}
	}
	
	
//	private static GS_RWElement getShortCut(Element element) {
//		String name = element.getAttribute("name");
//		String source = element.getAttribute("source");
//		String uri = element.getAttribute(GSResource.URI);
//		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
//		String version = element.getAttribute(GSResource.VERSION);
//		ShortCut shortcut = new ShortCut();
//		shortcut.setName(name);
//		shortcut.setString(source);
//		NodeList list = element.getChildNodes();
//		GS_RWElement resource = null;
//		for(int i=0;i<list.getLength();i++){
//			if(list.item(i).getNodeType() == Node.ELEMENT_NODE){
//				resource = XML2RWElementConverter.convert((Element)list.item(i));	
//				if (resource != null) {
//					shortcut.setResource(resource);
//				}
//			}
//		}
//		if (resource == null) {
//			System.out.println("Error in getShortCut: a null-resource ShortCut is made for URI: " + uri);
//		}
//		shortcut.setURIs(uri, originalURI);
//		shortcut.setVersion(version);
//		return shortcut;
//	}

	private static GS_RWElement getShortCut(Element element) {
	   return ShortCut.restore(element);
	}

//	private static GS_RWElement getQuery(Element element) {
//		boolean hasSpread = new Boolean(element.getAttribute("hasSpread"));
//		String spreadURI = null;
//		String name = element.getAttribute("name");
//		String uri = element.getAttribute("uri");
//		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
//		String version = element.getAttribute(GSResource.VERSION);
//		if(hasSpread){
//			spreadURI = element.getAttribute("spreadURI");
//		}
//		int x = new Integer(element.getAttribute("x"));
//		int y = new Integer(element.getAttribute("y"));
//		int width = new Integer(element.getAttribute("width"));
//		int height = new Integer(element.getAttribute("height"));
//		
//		GSQuery query = null;
//		if(hasSpread){
//			Spread spread = (Spread)URISolver.getResource(spreadURI);
//			if (spread == null) {
//				return null;
//			}
//			query = new GSQuery(spread,spread.getDscFile(),new Rectangle(x,y,width,height));
//			query.setName(name);
//		}else{
//			String dscFilePath = element.getAttribute("dscfile");
//			String imagePath = element.getAttribute("imagePath");
//			Image image = null;
//			try {
//				
//				image = ImageIO.read(new File(imagePath));
//			} catch (IOException e) {
//				e.printStackTrace();
//			}
//			File dscFile = new  File(dscFilePath);
//			query = new GSQuery(image,dscFile,new Rectangle(x,y,width,height));
//			query.setName(name);
//		}
//		query.setVersion(version);
//		query.setURIs(uri, originalURI);
//		return query;
//	}

	private static GS_RWElement getQuery(Element element) {
		return GSQuery.getQuery(element);
	}

//	Class GS_RWPackage does not have the corresponding method.
	private static GS_RWPackage getPackage(Element element){
		String name = element.getAttribute("name");
		String source = element.getAttribute("source");
		String uri = element.getAttribute("uri");
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String version = element.getAttribute(GSResource.VERSION);
		GS_RWPackage gsPackage = new GS_RWPackage(uri,originalURI,version);
		gsPackage.setName(name);
		gsPackage.setSource(source);
		gsPackage.setVersion(version);
		
		NodeList children = element.getChildNodes();
		for(int i=0;i<children.getLength();i++){
			Node node = children.item(i); 
			if(node.getNodeType() == Node.ELEMENT_NODE){
				GS_RWElement child = XML2RWElementConverter.convert((Element)node);
				if (child == null) {
					System.out.println("Error: an element of the package of uri " + uri + " is not found. It is skipped: " + ((Element)node).toString());
					break;
				}
				gsPackage.add(child);
			}
		}
		return gsPackage;
	}
	
//	Class StandardTextDocument does not have the corresponding method.
	private static StandardTextDocument getStandardDocument(Element element){
		String uri = element.getAttribute("uri");
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String version = element.getAttribute(GSResource.VERSION);
		String name = element.getAttribute("name");
		String source = element.getAttribute("source");
		StandardTextDocument doc = new StandardTextDocument(source,name,uri,originalURI,version);
		doc.setVersion(version);
		return doc;

	}
	
}