/* $Id: ToolMenu.java 653 2013-02-08 09:35:06Z ohura $ */
package smart_gs.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import smart_gs.GSConstants;
import smart_gs.dictionary.DictionaryDialog;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.drawing_tool.drawing_mode.BookmarkMode;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.EraserMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.MemoPadMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.logical.GSResource;
import smart_gs.logical.ResourceBasket;
import smart_gs.logical.Region;
import smart_gs.logical.Sheet;
import smart_gs.logical.SpreadTree;
import smart_gs.menu.action.ResourceListAction;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.ResourceBasketsFrame;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.ImageToolBar;

/**
 * 2007/11/1 kazuhiro kobayashi
 * @author Administrator
 *
 */
public class ToolMenu extends JMenu implements ActionListener {

	private JMenuItem select;
	private JMenuItem eraser;
	private JMenuItem rectangle;
	private JMenuItem marker;
	private JMenuItem polygon;
	private JMenuItem memopad;
	private JMenu bookmark;
	private JMenuItem tmprectangle;
	private JMenuItem tmpmarker;
	private JMenuItem tmppolygon;
	private JMenuItem tmpbookmark;
	private JMenuItem insertBookmark;
	private JMenuItem bookmarkList;
	private JMenuItem resourceBasket;

	private JMenuItem zoomIn;
	private JMenuItem zoomOut;
	private JMenuItem fullSize;
	private JMenuItem fitWidth;
	private JMenuItem fitHeight;
	private JMenu showRegion;
	private AbstractGSWindow parent;
	private JMenuItem allRegions;
	private JMenuItem protectedRegions;
	private JMenuItem noRegions;
	private JMenuItem protectAllRegions;
	private JMenuItem releaseAllRegions;

	public ToolMenu(String title, AbstractGSWindow parent) {
		super(title);
		this.parent = parent;

		this.select = new JMenuItem("Select", new ImageIcon(
				GSConstants.ICON_PATH + "select.gif"));
		this.select.addActionListener(this);
		this.add(this.select);

		this.eraser = new JMenuItem("Eraser", new ImageIcon(
				GSConstants.ICON_PATH + "delete.gif"));
		this.eraser.addActionListener(this);
//		eraser.setAccelerator(KeyStroke.getKeyStroke("ctrl D"));
		this.add(this.eraser);

		this.addSeparator();

		this.rectangle = new JMenuItem("Rectangle");
		this.rectangle.addActionListener(this);
		this.add(this.rectangle);

		this.marker = new JMenuItem("Marker");
		this.marker.addActionListener(this);
		this.add(this.marker);

		this.polygon = new JMenuItem("Polygon");
		this.polygon.addActionListener(this);
		this.add(this.polygon);

		this.memopad = new JMenuItem("MemoPad");
		this.memopad.addActionListener(this);
		this.add(this.memopad);

		
		this.bookmark = new JMenu("Bookmark");
		this.add(this.bookmark);
		this.insertBookmark = new JMenuItem("Insert");
		this.insertBookmark.addActionListener(this);
		bookmark.add(this.insertBookmark);
		this.bookmarkList = new JMenuItem("List");
		this.bookmarkList.addActionListener(this);
		bookmark.add(this.bookmarkList);
		
		this.tmprectangle = new JMenuItem("tmp Rectangle");
		this.tmprectangle.addActionListener(this);
		this.add(this.tmprectangle);

		this.tmpmarker = new JMenuItem("tmp Marker");
		this.tmpmarker.addActionListener(this);
		this.add(this.tmpmarker);

		this.tmppolygon = new JMenuItem("tmp Polygon");
		this.tmppolygon.addActionListener(this);
		this.add(this.tmppolygon);
		
		this.tmpbookmark = new JMenuItem("tmp Bookmark");
		this.add(this.tmpbookmark);
		this.tmpbookmark.addActionListener(this);
		this.add(this.tmpbookmark);
		
		this.resourceBasket = new JMenuItem("Resource Basket");
		this.resourceBasket.addActionListener(this);
		this.add(this.resourceBasket);

		this.addSeparator();

		this.zoomIn = new JMenuItem("Zoom in", new ImageIcon(
				GSConstants.ICON_PATH + "zoom_in.gif"));
		this.zoomIn.addActionListener(this);
		this.add(this.zoomIn);

		this.zoomOut = new JMenuItem("Zoom out", new ImageIcon(
				GSConstants.ICON_PATH + "zoom_out.gif"));
		this.zoomOut.addActionListener(this);
		this.add(this.zoomOut);
		
		this.fullSize = new JMenuItem("Full Size");
		this.fullSize.addActionListener(this);
		this.add(this.fullSize);
		
		this.fitWidth = new JMenuItem("Fit Width");
		this.fitWidth.addActionListener(this);
		this.add(this.fitWidth);
		
		this.fitHeight = new JMenuItem("Fit Height");
		this.fitHeight.addActionListener(this);
		this.add(this.fitHeight);

		this.addSeparator();

		this.showRegion = new JMenu("Show Region");
		this.add(this.showRegion);
		
		this.allRegions = new JMenuItem("All Regions");
		this.allRegions.addActionListener(this);
		this.add(this.allRegions);
		
		this.protectedRegions = new JMenuItem("Protected Regions");
		this.protectedRegions.addActionListener(this);
		this.add(this.protectedRegions);
		
		this.noRegions = new JMenuItem("No Region");
		this.noRegions.addActionListener(this);
		this.add(this.noRegions);
		
		this.showRegion.add(this.allRegions);
		this.showRegion.add(this.protectedRegions);
		this.showRegion.add(this.noRegions);

		// 2010/11 kukita 
		this.protectAllRegions = new JMenuItem("Protect All Regions");
		this.protectAllRegions.addActionListener(this);
		this.add(this.protectAllRegions);
		
		// 2010/11 kukita 
		this.releaseAllRegions = new JMenuItem("Release All Reagions");
		this.releaseAllRegions.addActionListener(this);
		this.add(this.releaseAllRegions);

		this.addSeparator();
		JMenuItem dictionary = new JMenuItem("Dictionary");
		dictionary.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				DictionaryDialog dictionaryDialog = new DictionaryDialog(WorkspaceWindow.getInstance(),"Dictionary",false,0);
				dictionaryDialog.setVisible(true);
			}
		});
		this.add(dictionary);
	}

	public void actionPerformed(ActionEvent e) {
		ImageToolBar imagetoolbar = WorkspaceWindow.getInstance().getImageToolBar();
		if (e.getSource().equals(this.select)) {
			DefaultState.getInstance()
					.setMode(DefaultDrawingMode.getInstance());
			imagetoolbar.setMode(ImageToolBar.modeNone);
		} else if (e.getSource().equals(this.rectangle)) {
			Mode mode0 = RectangleMode.getInstance();
			mode0.setTemporary(false);
			DefaultState.getInstance().setMode(mode0);
			imagetoolbar.setMode(ImageToolBar.modeRectangle);
		} else if (e.getSource().equals(this.tmprectangle)) {
			Mode mode0 = RectangleMode.getInstance();
			mode0.setTemporary(true);
			DefaultState.getInstance().setMode(mode0);
			imagetoolbar.setMode(ImageToolBar.modeTmpRectangle);
		} else if (e.getSource().equals(this.marker)) {
			Mode mode0 = MarkerMode.getInstance();
			mode0.setTemporary(false);
			DefaultState.getInstance().setMode(mode0);
			imagetoolbar.setMode(ImageToolBar.modeMarker);
		} else if (e.getSource().equals(this.tmpmarker)) {
			Mode mode0 = MarkerMode.getInstance();
			mode0.setTemporary(true);
			DefaultState.getInstance().setMode(mode0);
			imagetoolbar.setMode(ImageToolBar.modeTmpMarker);
		} else if (e.getSource().equals(this.polygon)) {
			Mode mode0 = PolygonMode.getInstance();
			mode0.setTemporary(false);
			DefaultState.getInstance().setMode(mode0);
			imagetoolbar.setMode(ImageToolBar.modePolygon);
		} else if (e.getSource().equals(this.tmppolygon)) {
			Mode mode0 = PolygonMode.getInstance();
			mode0.setTemporary(true);
			DefaultState.getInstance().setMode(mode0);
			imagetoolbar.setMode(ImageToolBar.modeTmpPolygon);
		} else if (e.getSource().equals(this.memopad)) {
			DefaultState.getInstance().setMode(MemoPadMode.getInstance());
			imagetoolbar.setMode(ImageToolBar.modeMemoPad);
		} else if (e.getSource().equals(this.insertBookmark)) {
			Mode mode0 = BookmarkMode.getInstance();
			mode0.setTemporary(false);
			DefaultState.getInstance().setMode(mode0);
			imagetoolbar.setMode(ImageToolBar.modeBookmark);
		} else if (e.getSource().equals(this.bookmarkList)) {
			List<GSResource> bookmarks = SpreadTree.getInstance().getBookmarks();
			
			new ResourceListAction(
						new ResourceBasket(bookmarks, "Bookmark"),
						true
					).actionPerformed(e);
			parent.repaint();
		} else if (e.getSource().equals(this.tmpbookmark)) {
			Mode mode0 = MarkerMode.getInstance();
			mode0.setTemporary(true);
			DefaultState.getInstance().setMode(mode0);
			imagetoolbar.setMode(ImageToolBar.modeTmpBookmark);	
		} else if (e.getSource().equals(this.resourceBasket)) {
			ResourceBasketsFrame.getInstance().showResourceBasketFrame();
		} else if (e.getSource().equals(this.zoomIn)) {
			parent.getSpreadCanvas().zoomIn();
		} else if (e.getSource().equals(this.zoomOut)) {
			parent.getSpreadCanvas().zoomOut();
		} else if (e.getSource().equals(this.fullSize)) {
			parent.getSpreadCanvas().fullSize();
		} else if (e.getSource().equals(this.fitWidth)) {
			parent.getSpreadCanvas().fitWidth();
		} else if (e.getSource().equals(this.fitHeight)) {
			parent.getSpreadCanvas().fitHeight();
		} else if (e.getSource().equals(this.eraser)) {
			DefaultState.getInstance().setMode(EraserMode.getInstance());
			imagetoolbar.setMode(ImageToolBar.modeEraser);
//			Region region = UniSelectedState.getInstance().getSelectedRegion();
//			new DeleteRegionAction(region).execute();
			parent.repaint();
		} else if (e.getSource().equals(this.allRegions)) {
			imagetoolbar.setShowRegionItem(ImageToolBar.showAll);
			parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_ALL_REGIONS);
			parent.repaint();
		} else if (e.getSource().equals(this.protectedRegions)) {
			imagetoolbar.setShowRegionItem(ImageToolBar.showProtected);
			parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_PROTECTED_REGIONS);
			parent.repaint();
		} else if (e.getSource().equals(this.noRegions)) {
			imagetoolbar.setShowRegionItem(ImageToolBar.showNo);
			parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_NO_REGIONS);
			parent.repaint();
		} else if (e.getSource().equals(this.protectAllRegions)) {
			parent.getSpreadCanvas().protectAllRegions();
		} else if (e.getSource().equals(this.releaseAllRegions)) {
			parent.getSpreadCanvas().releaseAllRegions();
		}
	}
}