/* $Id: SearchMenu.java 650 2013-02-08 00:48:06Z ohura $ */
package smart_gs.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import smart_gs.dictionary.DictionaryDialog;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.CurrentTextSearchActionListener;
import smart_gs.swingui.toolbar.action.SearchActionListener;
import smart_gs.swingui.toolbar.action.Text2ImageActionListener;

public class SearchMenu extends JMenu {
	
	public SearchMenu(String title, AbstractGSWindow parent){
		super(title);
		
		JMenuItem Search = new JMenuItem("Search");
		this.add(Search);
		Search.addActionListener(new SearchActionListener(parent));
		
		JMenuItem text2Image = new JMenuItem("Text-Image");
		text2Image.addActionListener(new Text2ImageActionListener());
//		this.add(text2Image);
	
		JMenuItem ctextSearch = new JMenuItem("Text Search");
		ctextSearch.setAccelerator(KeyStroke.getKeyStroke("ctrl T"));
		ctextSearch.addActionListener(new CurrentTextSearchActionListener());
		this.add(ctextSearch);

		JMenuItem makeSeachlist = new JMenuItem("SpreadSelectionList");
		makeSeachlist.addActionListener(new SpreadSelectionListListener());
		this.add(makeSeachlist);
	
	}

}
