/* $Id: ToolBarPanel.java 535 2012-08-21 04:55:59Z shayashi $ */
package smart_gs.swingui;

import java.awt.FlowLayout;
import java.awt.GridLayout;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

import smart_gs.GSConstants;
import smart_gs.swingui.toolbar.DefaultToolBar;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.HistoryToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.MoveTreeToolBar;
import smart_gs.swingui.toolbar.UtilityToolBar;
import smart_gs.swingui.toolbar.SearchToolBar;
import smart_gs.swingui.toolbar.action.ShowLinesActionListener;
import sml_editor.swingui.EditorTextPane;
@SuppressWarnings("serial")
public class ToolBarPanel extends JPanel{
	
	private GSEditorToolBar editorToolBar;
	private HistoryToolBar historyToolBar;
	private MoveTreeToolBar moveTreeToolBar;
	private ImageToolBar imageToolBar;

	public ToolBarPanel(AbstractGSWindow parent, boolean isInWorkspaceWindow, boolean isHorizontallyLong){
//		super(new GridLayout(isHorizontallyLong?1:2,1));
		super(new GridLayout(1,1));
		// Ignore the wide, since there are not so many items at present.

		JPanel panel1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		if (isInWorkspaceWindow) panel1.add(new DefaultToolBar());
		imageToolBar = new ImageToolBar(parent);
		panel1.add(imageToolBar);
		panel1.add(new SearchToolBar(parent));
		this.add(panel1);


		panel1.add(new UtilityToolBar(parent,isInWorkspaceWindow));
		
		if (isInWorkspaceWindow) {
			historyToolBar = new HistoryToolBar(parent);
			panel1.add(historyToolBar);
		}
		
		moveTreeToolBar = new MoveTreeToolBar(parent);
		panel1.add(moveTreeToolBar);
		
		this.add(panel1);
	
	}
	

//	public void setEditorTextPane(EditorTextPane textPane){
//		this.validate();
//	}

	public GSEditorToolBar getGSEditorToolBar(){
		return editorToolBar;
	}
	public HistoryToolBar getHistoryToolBar(){
		return historyToolBar;
	}
	public MoveTreeToolBar getMoveTreeToolBar(){
		return moveTreeToolBar;
	}
	public ImageToolBar getImageToolBar() {
		return imageToolBar;
	}
}
