package smart_gs.menu.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import smart_gs.swingui.WorkspaceWindow;
import webdav.WebDavDownLoadEvent;
import webdav.WebDavListenerAction;

public class NewFileActionListener implements ActionListener {

	@Override
	public void actionPerformed(ActionEvent arg0) {
		WorkspaceWindow window = WorkspaceWindow.getInstance();
		if( WorkspaceWindow.isUpdated() ){
			String filename = null;
			if(window.getLastsave() == 0){
				if(window.getCurrentFile() != null){
					filename = window.getCurrentFile().getName();
				}
			}else{
				WebDavDownLoadEvent webDavDownLoadEvent = window.getWebDavDownLoadEvent();
				if(webDavDownLoadEvent != null){
					filename = webDavDownLoadEvent.getDownloaname();
				}
			}
			int input = JOptionPane.showConfirmDialog(window,  
					(filename == null ? 
							"Save the edited contents?" :
							"\""+ filename + "\" has been modified. Do you want to save your changes?")
					);
			
			if (input == JOptionPane.OK_OPTION) {
				
				if(window.getLastsave() == 0){
					if( window.saveAll() == false ) return;
				}else{
					WebDavListenerAction webDavListenerAction = new WebDavListenerAction();
					webDavListenerAction.save();
				}
			} else if (input == JOptionPane.NO_OPTION) {
				WorkspaceWindow.setUpdated(false);
			} else if (input == JOptionPane.CANCEL_OPTION) {
				return;
			}
		}		

		WorkspaceWindow.getInstance().setCurrentFile(null);
		WorkspaceWindow.getInstance().close();

	}

}
