package smart_gs.drawing_tool;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

import smart_gs.connection.ConnectionCreator;
import smart_gs.dictionary.DictionaryRegisterDialog;
import smart_gs.drawing_tool.action.AddToBasketAction;
import smart_gs.drawing_tool.action.AnchorJumpToLinkedTextActionListener;
import smart_gs.drawing_tool.action.BookmarkSizeAction;
import smart_gs.drawing_tool.action.ChangeBreadthAction;
import smart_gs.drawing_tool.action.ChangeColorAction;
import smart_gs.drawing_tool.action.ChangeRegionTitleAction;
import smart_gs.drawing_tool.action.CloseUpViewerAction;
import smart_gs.drawing_tool.action.CreateShortCutAction;
import smart_gs.drawing_tool.action.DeleteArrowAction;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.drawing_tool.action.MemoPadTextAction;
import smart_gs.drawing_tool.action.NextRegionAction;
import smart_gs.drawing_tool.action.ProtectRegionAction;
import smart_gs.drawing_tool.action.ReleaseProtectedRegionAction;
import smart_gs.drawing_tool.action.SetLinkSourceAction;
import smart_gs.drawing_tool.action.SetLinkTargetAction;
import smart_gs.drawing_tool.action.DrawArrowAction;
import smart_gs.drawing_tool.action.cancelConnectionCreationAction;
import smart_gs.drawing_tool.state.LineSegEditorUniSelectedState;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.GSResource;
import smart_gs.logical.Region;
import smart_gs.logical.ResourceBasket;
import smart_gs.logical.TextSegment;
import smart_gs.logical.region.AnchorRegion;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.logical.visitor.ShowResourceVisitor;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;

@SuppressWarnings("serial")
public class LineSegEditorRightClickMenu extends JPopupMenu{	
	
	public LineSegEditorRightClickMenu(final Region region, LineSegEditorCanvas canvas, final LineSegEditorUniSelectedState lineSegEditorUniSelectedState) {
		String title = region.getView().getTitle();
		JMenuItem displayTitle = new JMenuItem("Title: " + title);
		displayTitle.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				new ChangeRegionTitleAction(region).execute();
			}
		});
		this.add(displayTitle);
		this.addSeparator();

		this.addSeparator();
		
		if (region.isProtected().equals(Region.NORMAL)){
			JMenuItem protectRegion = new JMenuItem("Protect Markup");
			protectRegion.addActionListener(new ProtectRegionAction(region));
			this.add(protectRegion);
		} else {
			JMenuItem releaseProtectedRegion = new JMenuItem("Release Protected Markup");
			releaseProtectedRegion.addActionListener(new ReleaseProtectedRegionAction(region));
			this.add(releaseProtectedRegion);
		}
		
		/**
		 *
		 */
		JMenuItem registDic = new JMenuItem("Register in the dictionary");
		registDic.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				DictionaryRegisterDialog dialog = new DictionaryRegisterDialog(WorkspaceWindow.getInstance(), "Register" , true,region);
				dialog.setVisible(true);
			}
		});
		this.add(registDic);
		
	}
	
}
