package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

import javax.swing.JOptionPane;

import org.apache.commons.io.FileUtils;

import smart_gs.logical.Spread;
import smart_gs.swingui.AbstractGSWindow;

public class DeleteDscFileAction implements ActionListener {
	private AbstractGSWindow gsWindow;
	private Spread spread;
	public DeleteDscFileAction(AbstractGSWindow parent) {
		this.gsWindow = parent;
	}

	public void actionPerformed(ActionEvent e) {
		this.spread = this.gsWindow.getSpread();

		String folderPath = Spread.DSC_FOLDER_PATH+spread.getSpreadDirParent().getPath();
		String filename = spread.getFileNameWithoutExtension();
		File file = new File(folderPath  + "dsc/" + filename + ".dsc");
		if (!file.exists()){
			JOptionPane.showMessageDialog(null,"DSC File does not exist");
			return;
		} else {
			try {
				FileUtils.forceDelete(file);
			} catch (IOException e1) {
				e1.printStackTrace();
			}
		}
		
		if (!file.exists()){
			JOptionPane.showMessageDialog(null,filename + ".dsc deleted");
		} else {
			JOptionPane.showMessageDialog(null,"failed to delete " + filename + ".dsc");
		}
	}
}
