/* $Id: MoveTreeToolBar.java 350 2011-09-11 15:16:44Z ohura $ */
package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.ImageLabel.Show;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

@SuppressWarnings("serial")
public class MoveTreeToolBar extends JToolBar implements ActionListener{
	protected JButton prev;
	protected JButton next;
	
	protected int historycounter = 0;
	protected int pathCount = 0;
	
	private AbstractGSWindow parent;
	public MoveTreeToolBar(AbstractGSWindow parent) {
		prev = new JButton(new ImageIcon(GSConstants.ICON_PATH + "prev_page.png"));
		prev.setEnabled(false);
		prev.addActionListener(this);
		prev.setActionCommand("prev");
		prev.setToolTipText("Previous page (Alt + UP)");
		prev.setMnemonic(KeyEvent.VK_UP);
		this.add(prev);

		next = new JButton(new ImageIcon(GSConstants.ICON_PATH + "next_page.png"));
		next.setEnabled(false);
		next.addActionListener(this);
		next.setActionCommand("next");
		next.setToolTipText("Next page (Alt + DOWN)");
		next.setMnemonic(KeyEvent.VK_DOWN);
		this.add(next);

		this.parent = parent;
	}

	public void actionPerformed(ActionEvent e) {
		int scale = parent.getSpreadCanvas().imageLabel.scale;
		Show lineSegment = parent.getSpreadCanvas().imageLabel.getLineSegmentShowingMode();
		if(e.getActionCommand().equals("next")){
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount + 1);
			if(spread != null) {
				if(!(parent instanceof GSEditor)) {
					WorkspaceWindow.getInstance().setSpread(spread);
					WorkspaceWindow.getInstance().setImageSearch(spread.toString());
					WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.setScale(scale);
					WorkspaceWindow.getInstance().getHistoryToolBar().setHistoryCanvasScale(scale);
					WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.setLineSegmentShowingMode(lineSegment);
					WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.showImage();
				} else { // GSEditor
					((GSEditor) parent).getSMLTabbedPane().setSpread(spread);
					((GSEditor) parent).getSMLTabbedPane().getSpreadCanvas().imageLabel.setScale(scale);
					((GSEditor) parent).getSMLTabbedPane().getSpreadCanvas().imageLabel.setLineSegmentShowingMode(lineSegment);
					((GSEditor) parent).getSMLTabbedPane().getSpreadCanvas().imageLabel.showImage();
					((GSEditor) parent).updateMoveToolBar();
				}
			}
		} else if(e.getActionCommand().equals("prev")) {
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount - 1);
			if(spread != null) {
				if(!(parent instanceof GSEditor)) {
					WorkspaceWindow.getInstance().setSpread(spread);
					WorkspaceWindow.getInstance().setImageSearch(spread.toString());
					WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.setScale(scale);
					WorkspaceWindow.getInstance().getHistoryToolBar().setHistoryCanvasScale(scale);
					WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.setLineSegmentShowingMode(lineSegment);
					WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.showImage();
				} else { // GSEditor
					((GSEditor) parent).getSMLTabbedPane().setSpread(spread);
					((GSEditor) parent).getSMLTabbedPane().getSpreadCanvas().imageLabel.setScale(scale);
					((GSEditor) parent).getSMLTabbedPane().getSpreadCanvas().imageLabel.setLineSegmentShowingMode(lineSegment);
					((GSEditor) parent).getSMLTabbedPane().getSpreadCanvas().imageLabel.showImage();
					((GSEditor) parent).updateMoveToolBar();
				}
			}
		}
	}

	public void setPathCount(int pathCount){
		this.pathCount = pathCount;
		{
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount + 1);
			if(spread != null){
				next.setEnabled(true);
			}else{
				next.setEnabled(false);
			}
		}
		{
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount - 1);
			if(spread != null){
				prev.setEnabled(true);
			}else{
				prev.setEnabled(false);
			}
		}
	}
}
