/* $Id: FileMenu.java 384 2011-10-07 17:03:43Z shayashi $ */
package smart_gs.menu;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import smart_gs.menu.action.ExitActionListener;
import smart_gs.menu.action.ImportGSFileListner;
import smart_gs.menu.action.OpenOldVersionActionListener;
import smart_gs.menu.action.ShowVersionAction;
import smart_gs.swingui.toolbar.action.OpenActionListener;
import smart_gs.swingui.toolbar.action.SaveActionListener;
import smart_gs.swingui.toolbar.action.TextExportActionListener;
import smart_gs.swingui.toolbar.action.WebDavSyncActionListener;
@SuppressWarnings("serial")

public class FileMenu extends JMenu{
	
	public FileMenu(String title) {
		super(title);
		//2007/11/1 kazuhiro kobayashi
		JMenuItem open = new JMenuItem("Open");
		open.addActionListener(new OpenActionListener(0));
		open.setAccelerator(KeyStroke.getKeyStroke("ctrl O"));
		this.add(open);
		
		//2011/06/06 kukita
		JMenuItem openOldVersion = new JMenuItem("Convert GS File to GSX File and Open");
		openOldVersion.addActionListener(new OpenOldVersionActionListener(0));
		this.add(openOldVersion);

		JMenuItem save = new JMenuItem("Save");
		save.addActionListener(new SaveActionListener(0));
		save.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
		this.add(save);

//		20110328 shayashi
		JMenuItem importGSfile = new JMenuItem("Import");
		importGSfile.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
		importGSfile.addActionListener(new ImportGSFileListner(0));
		this.add(importGSfile);
		importGSfile.setEnabled(false);

		
		JMenuItem export = new JMenuItem("Export");
		export.addActionListener(new TextExportActionListener());
		export.setAccelerator(KeyStroke.getKeyStroke("ctrl E"));
		this.add(export);
		export.setEnabled(false);
		
		this.addSeparator();
		JMenuItem openwebdav = new JMenuItem("Open from WebDAV");
		openwebdav.addActionListener(new OpenActionListener(1));
		openwebdav.setAccelerator(KeyStroke.getKeyStroke("ctrl G"));
		this.add(openwebdav);

		JMenuItem savewebdav = new JMenuItem("Save to WebDAV");
		savewebdav.addActionListener(new SaveActionListener(1));
		savewebdav.setAccelerator(KeyStroke.getKeyStroke("ctrl H"));
		this.add(savewebdav);

		this.addSeparator();
		JMenuItem syncwebdav = new JMenuItem("Synchronize with WebDAV");
		syncwebdav.addActionListener(new WebDavSyncActionListener());
		syncwebdav.setAccelerator(KeyStroke.getKeyStroke("ctrl J"));
		this.add(syncwebdav);

		this.addSeparator();
		
		JMenuItem exit = new JMenuItem("Exit");
		exit.addActionListener(new ExitActionListener());
		exit.setAccelerator(KeyStroke.getKeyStroke("ctrl W"));
		this.add(exit);
		
		
		JMenuItem forVersion = new JMenuItem("Version");
	    forVersion.addActionListener(new ShowVersionAction());
		this.add(forVersion);
	}
}
