package smart_gs.drawing_tool;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import smart_gs.drawing_tool.drawing_mode.BookmarkMode;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.EraserMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.MemoPadMode;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.swingui.toolbar.ImageToolBar;

public class DrawingModeSelectionPopupMenu extends JPopupMenu {

	public DrawingModeSelectionPopupMenu() {
		
		JMenuItem none = new JMenuItem("<none>");
		none.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
				ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeNone]);
			}
		});
		this.add(none);

		JMenuItem rect = new JMenuItem("Rectangle");
		rect.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				DefaultState.getInstance().setMode(RectangleMode.getInstance());
				ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeRectangle]);
			}
		});
		this.add(rect);

		JMenuItem marker = new JMenuItem("Marker");
		marker.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				DefaultState.getInstance().setMode(MarkerMode.getInstance());
				ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeMarker]);
			}
		});
		this.add(marker);

		JMenuItem polygon = new JMenuItem("Polygon");
		polygon.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				DefaultState.getInstance().setMode(PolygonMode.getInstance());
				ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modePolygon]);
			}
		});
		this.add(polygon);

		JMenuItem memo = new JMenuItem("MemoPad");
		memo.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				DefaultState.getInstance().setMode(MemoPadMode.getInstance());
				ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeMemoPad]);
			}
		});
		this.add(memo);

		JMenuItem bookmark = new JMenuItem("Bookmark");
		bookmark.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				DefaultState.getInstance().setMode(BookmarkMode.getInstance());
				ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeBookmark]);
			}
		});
		this.add(bookmark);

		JMenuItem eraser = new JMenuItem("Eraser");
		eraser.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				DefaultState.getInstance().setMode(EraserMode.getInstance());
				ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeEraser]);
			}
		});
		this.add(eraser);		
	}
}
