package smart_gs.logical;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import smart_gs.debugprint.Debugprint;
import smart_gs.logical.visitor.Visitor;
import smart_gs.reasoning_web.logical.ExpNoteManager;
import smart_gs.reasoning_web.logical.GSConnection;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GSResourcePointer;
import smart_gs.swingui.ResourceBasketsFrame;

public class ResourceBasket extends GSResource {
	public static final String RESOURCE_URI = "resourceURI";
	private List<GSResource> resources;
	private String name;
	private boolean toBeSaved = false;
	
	public ResourceBasket(List<GSResource> resources, String name) {
		super();
		if (resources == null) {
			this.resources = new ArrayList<GSResource>();
		} else {
			this.resources = resources;
		}
		this.name = name;
		this.setURIs();
	}
	
	public ResourceBasket(String uri, String originalURI, String version, String name) {
		this.setURIs(uri,originalURI);
		this.version = version;
		this.name = name;
		this.resources = new ArrayList<GSResource>();
	}

	public String toString() {
		return this.name;
	}
	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}

	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}

	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}

	@Override
	public String getTypeString() {
		return URIObject.RESOURCE_BASKET;
	}

	public List<GSResource> getResources() {
		return this.resources;
	}

	public void addResource(GSResource resource) {
		if (!this.resources.contains(resource)) {
			this.resources.add(resource);		
		}
	}

	public static ResourceBasket restore(Element element) {
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String version = element.getAttribute(GSResource.VERSION);
		String name = element.getAttribute(GSResource.NAME);

		ResourceBasket basket = new ResourceBasket(uri, originalURI, version, name);
		NodeList list = element.getElementsByTagName(ResourceBasket.RESOURCE_URI);
		for (int i = 0; i < list.getLength(); i++) {
			String resourceURI = list.item(i).getTextContent();
			GSResource resource = URISolver.getResource(resourceURI);
			if (resource == null) {
				System.out.println(String.format("Error: resource %s is not found. Making a zombie for a resource pointer", resourceURI));
				resource = new Zombie(uri); 
			}
			basket.addResource(resource);
		}
		return basket;

	}

	public void removeResource(GSResource resource) {
		this.resources.remove(resource);
	}

	public boolean contains(GSResource resource) {
		return this.resources.contains(resource);
	}

	public int getLength() {
		return this.resources.size();
	}

	public void setToBeSaved(boolean toBeSaved) {
		this.toBeSaved = toBeSaved;
	}

	public boolean toBeSaved() {
		return this.toBeSaved;
	}
}
