/* $Id: MarkupDialog.java 125 2011-03-09 09:49:51Z ohura $ */
package sml_editor.swingui;

/*
 * 쐬: 2006/04/23
 *
 */

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

import smart_gs.util.LinkCounter;



/**
 * @author kazuaki kobayashi
 *
 */
public class MarkupDialog{
	
	protected EditorTextPane textPane;
	protected int start;
	protected int end;
	protected int id;
	protected String tagname = null;
	/**
	 * @param pane
	 * @param start
	 * @param end
	 */
	public MarkupDialog(EditorTextPane textPane, int start, int end) {
		this.textPane = textPane;
		this.start = start;
		this.end = end;
//		this.id = this.hashCode() % 1000;
	}
	public void show(){

		Object[] objects = this.makeTagList();
/*		String tagName = (String) JOptionPane.showInputDialog(new JFrame(),"select tag","Mark up",JOptionPane.OK_CANCEL_OPTION,
														  null,objects,objects[0]);
 */
		
		MarkupInputDialog markupInputDialog = new MarkupInputDialog(new JFrame(),"Mark up",true,objects);
		markupInputDialog.setLocationRelativeTo(null);
	    markupInputDialog.setResizable(false); 
	    markupInputDialog.setVisible(true);
	    String tagName = markupInputDialog.getSelectComboBox();
		if(tagName == null){
			return ;
		}
		this.id = LinkCounter.getID();
		this.tagname = tagName;
		this.textPane.createHyperlink(tagname,String.valueOf(id));
		
		Properties property = new Properties();
		property.put("id",""+id);
//		this.textPane.getGSHTMLEditorTextPane().getController().makeTag(this.start, this.end, tagName, property);
		this.textPane.getGSHTMLEditorTextPane().updateText();
		//2007/10/25 kazuhrio kobayashi
		this.textPane.setCaretPosition(start);
		this.textPane.getGSHTMLEditorTextPane().addTagList(tagName);
	}
	protected String getTagName(){
		return this.tagname;
	}
	private Object[] makeTagList(){
	   Vector<String> taglist = new Vector<String>();
	   String line;
	   try{
		   BufferedReader reader = new BufferedReader(new FileReader("tags.txt"));
		   while((line = reader.readLine()) != null){
			   taglist.add(line.trim());
		   }
	   }
	   catch(IOException e){
		   e.printStackTrace();
	   }
	   List<String> tagnames = this.textPane.getGSHTMLEditorTextPane().getTagNames();
	   if(tagnames != null){
		   for(int i=0;i<tagnames.size();i++){
			   if(!taglist.contains(tagnames.get(i).trim())){
				   taglist.add(tagnames.get(i).trim());
			   }
		   }
	   }
	   
	   return taglist.toArray();
	}
}
