/* $Id: ImageCropper.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

import smart_gs.logical.Region;
import smart_gs.logical.Spread;
/**
 * 
 * @author kazuaki kobayashi
 * 
 *  spread̗̓̈\摜쐬NX
 *  
 *  
 */
public class ImageCropper {
	
	private Image image;
	private Rectangle2D rectangle;
	
	private int x;
	private int y;
	private int w;
	private int h;
	
	public ImageCropper(Region region){
		this.image = region.getSpread().getImage();
		this.rectangle = region.getView().getRectangle2D();
		this.x = (int)rectangle.getX();
		this.y = (int)rectangle.getY();
		this.w = (int)rectangle.getWidth();
		this.h = (int)rectangle.getHeight();
	}
	public ImageCropper(Spread spread,Rectangle2D rectangle){
		this.image = spread.getImage();
		this.rectangle = rectangle;
		this.x = (int)rectangle.getX();
		this.y = (int)rectangle.getY();
		this.w = (int)rectangle.getWidth();
		this.h = (int)rectangle.getHeight();
	}
	
	
	public ImageCropper(Image image,Rectangle2D rectangle){
		this.image = image;
		this.rectangle = rectangle;
		this.x = (int)rectangle.getX();
		this.y = (int)rectangle.getY();
		this.w = (int)rectangle.getWidth();
		this.h = (int)rectangle.getHeight();
	}
	public Image crop(){	
		BufferedImage bufImage = new BufferedImage(w,h,BufferedImage.TYPE_INT_RGB);
		Graphics offg = bufImage.getGraphics();
		offg.drawImage(image,0,0,w,h,x,y,x+w,y+h,null);
		
		return bufImage;
	}
	public Image crop(int width,int height){
		Image img = this.crop();
		BufferedImage bufImage = new BufferedImage(width,height,BufferedImage.TYPE_INT_RGB);
		Graphics offg = bufImage.getGraphics();
		offg.drawImage(img,0,0,width,height,0,0,w,h,null);
		return bufImage;
	}
}
