package smart_gs.util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

/**
 * t@C̃Rs[쐬TvłB
 *
 */
public class FileCopy {

	public static void copy(String sourceFileString, String parentDirString) {
		File sourceFile = new File(sourceFileString);
		File parentDir = new File(parentDirString);
		copy(sourceFile,parentDir);
	}

	public static void copy(File sourceFile, File parentDir) {
		FileChannel ifc = null;
		FileChannel ofc = null;
		File destinationFile = new File(parentDir,sourceFile.getName());
		String sourceFileName = CanonicalPathString.get(sourceFile);
		String destFileName = CanonicalPathString.get(destinationFile);
		if (destFileName.equals(sourceFileName)) {
			System.out.printf("Skipping to copy %s:\nsouce and target identical\n", destinationFile.getPath());
			return;
		}
		try {
			// ͌t@C̃Xg[`l擾
			FileInputStream fis = new FileInputStream(sourceFile);
			ifc = fis.getChannel();
			String newFileName = sourceFile.getName();

			// o͐t@C̃`l擾
			File outFile = new File(parentDir, newFileName);
			FileOutputStream fos = new FileOutputStream(outFile);
			ofc = fos.getChannel();

			// oCg]܂B
			ifc.transferTo(0, ifc.size(), ofc);

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (ifc != null) {
				try {
					// ̓`l close ܂B
					ifc.close();
				} catch (IOException e) {
				}
			}
			if (ofc != null) {
				try {
					// o̓`l close ܂B
					ofc.close();
				} catch (IOException e) {
				}
			}
		}
	}
}
	