/* $Id: GSWysiwygMouseListener.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.smleditor.swingui;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.swing.JComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;

import org.w3c.dom.Element;

import smart_gs.connection.ConnectionCreator;
import smart_gs.drawing_tool.action.JumpWebPageAction;
import smart_gs.logical.TextSegment;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;
import smart_gs.util.HrefChecker;
import sml_editor.swingui.wysiwyg.WysiwygMouseListener;


public class GSWysiwygMouseListener extends WysiwygMouseListener {
	// ADD NorthGird 20090224
	protected boolean markupflg = false;
	
	public GSWysiwygMouseListener(GSEditorTextPane textPane) {
		super(textPane);
	}
	@Override
	public void mouseClicked(MouseEvent e) {
		super.mouseClicked(e);
		if(e.getButton() == MouseEvent.BUTTON3){
			SimpleAttributeSet element = textPane.getSelectID(e.getPoint());
			if(element == null){
				JComponent component = ( JComponent ) e.getSource();
				new GSEditorPopupMenu2(textPane).show(textPane,e.getX() + component.getX(),e.getY() + component.getY());
				return;
			}
			
			boolean href = false;
			String id = (String)element.getAttribute(HTML.Attribute.HREF);
			TextSegment segment = null;
			if(id != null){
				int checkid = HrefChecker.check(id);
				if(checkid == -1){
					href = true;
				}else{
					segment = ((GSEditorTextPane)textPane).getSmartDocument().getSegmentByID(checkid);
				}
				/*
				 * show popup
				 */
				JComponent component = ( JComponent ) e.getSource();
				new GSEditorPopupMenu(segment,textPane,e.getPoint(),href).show(textPane,e.getX() + component.getX(),e.getY() + component.getY());

			}
		}
		if(e.getButton() == MouseEvent.BUTTON1){
			SimpleAttributeSet element = textPane.getSelectID(e.getPoint());
			if(element == null){
				return;
			}
			TextSegment segment =  null;
			String id = (String)element.getAttribute(HTML.Attribute.HREF);
			int checkid = HrefChecker.check(id);
			if(checkid == -1){
				if(e.getClickCount() == 2){
					new JumpWebPageAction(textPane,e.getPoint()).actionPerformed(null);
					return;
				}
			}else{
				segment = ((GSEditorTextPane)textPane).getSmartDocument().getSegmentByID(checkid);
			}
			if(segment != null){
				if(WorkspaceWindow.getInstance().isAlt() == true && WorkspaceWindow.getInstance().isCtrl() == true){
					new ShowLocalViewAction(segment).execute();
				}else if(WorkspaceWindow.getInstance().isAlt()){
					ConnectionCreator.setSource(segment);
				}else if(WorkspaceWindow.getInstance().isCtrl()){
					ConnectionCreator.setTarget(segment);
				}
				if(e.getClickCount() == 2){
					new ShowLocalViewAction(segment).execute();
				}
			}
		}

	}
	
}
