/* $Id: XML2RWElementConverter.java 158 2011-05-08 11:01:20Z ohura $ */
package smart_gs.reasoning_web.logical;

import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBacket;
import smart_gs.logical.Spread;
import smart_gs.logical.StandardTextDocument;
import smart_gs.logical.URISolver;
import smart_gs.logical.XML2ResourceConverter;
import smart_gs.reasoning_web.desktop.logical.ShortCut;

public class XML2RWElementConverter {
	
	public static GS_RWElement convert(Element element){
		String tagname = element.getNodeName();
		
		if(tagname.equals("standardDocument")){
			return getStandardDocument(element);
		}else if(tagname.equals("package")){
			return getPackage(element);
		}else if(tagname.equals("query")){
			return getQuery(element);
		}else if(tagname.equals("shortcut")){
			return getShortCut(element);
		}else if(tagname.equals("backet")){
			return QueryBacket.restore(element);
		}
		else{
			return XML2ResourceConverter.convert(element);
		}
		
	}
	
	
	private static GS_RWElement getShortCut(Element element) {
		String name = element.getAttribute("name");
		String source = element.getAttribute("source");
		ShortCut shortcut = new ShortCut();
		shortcut.setName(name);
		shortcut.setString(source);
		NodeList list = element.getChildNodes();
		for(int i=0;i<list.getLength();i++){
			if(list.item(i).getNodeType() == Node.ELEMENT_NODE){
				GS_RWElement resource = XML2RWElementConverter.convert((Element)list.item(i));
				
				shortcut.setResouce(resource);
			}
		}

		return shortcut;
	}


	private static GS_RWElement getQuery(Element element) {
		boolean hasSpread = new Boolean(element.getAttribute("hasSpread"));
		String spreadURI = null;
		String name = element.getAttribute("name");
		if(hasSpread){
			spreadURI = element.getAttribute("spreadURI");
		}
		int x = new Integer(element.getAttribute("x"));
		int y = new Integer(element.getAttribute("y"));
		int width = new Integer(element.getAttribute("width"));
		int height = new Integer(element.getAttribute("height"));
		
		GSQuery query = null;
		if(hasSpread){
			Spread spread = (Spread)URISolver.getResource(spreadURI);
			query = new GSQuery(spread,spread.getDscFile(),new Rectangle(x,y,width,height));
			query.setName(name);
		}else{
			String dscFilePath = element.getAttribute("dscfile");
			String imagePath = element.getAttribute("imagePath");
//			Image image = new ImageIcon(imagePath).getImage();
			Image image = null;
			try {
				
				image = ImageIO.read(new File(imagePath));
			} catch (IOException e) {
				e.printStackTrace();
			}
			File dscFile = new  File(dscFilePath);
			query = new GSQuery(image,dscFile,new Rectangle(x,y,width,height));
			query.setName(name);
		}
		return query;
	}


	private static GS_RWPackage getPackage(Element element){
		String name = element.getAttribute("name");
		String source = element.getAttribute("source");
		
		GS_RWPackage gsPackage = new GS_RWPackage();
		gsPackage.setName(name);
		gsPackage.setSource(source);
		
		NodeList children = element.getChildNodes();
		for(int i=0;i<children.getLength();i++){
			Node node = children.item(i); 
			if(node.getNodeType() == Node.ELEMENT_NODE){
				GS_RWElement child = XML2RWElementConverter.convert((Element)node);
				gsPackage.add(child);
			}
		}
		
		return gsPackage;
	}
	
	private static StandardTextDocument getStandardDocument(Element element){
		String uri = element.getAttribute("uri");
		String name = element.getAttribute("name");
		String source = element.getAttribute("source");
		return new StandardTextDocument(source,uri,name);
	}
}
