/* $Id: BookmarkOpenSelectionListener.java 158 2011-05-08 11:01:20Z ohura $ */
package smart_gs.menu.action;

import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import smart_gs.logical.BookmarkList;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.WorkspaceWindow;

public class BookmarkOpenSelectionListener extends JFrame 
			implements ListSelectionListener {

	private static boolean ALTERNATE = true;
	private BookmarkList list;

	public BookmarkOpenSelectionListener(BookmarkList list) {
		super("Open");
		this.list = list;
	}

	@Override
	public void valueChanged(ListSelectionEvent e) {
		if (ALTERNATE) {
			BookmarkRegion bookmark = (BookmarkRegion)(list.getSelectedValue());
			Spread spread = bookmark.getSpread();
			if(spread == null){
				return;
			}
			WorkspaceWindow.getInstance().tabbedPaneSave();
			GSEditor editor = new GSEditor(spread);
			editor.setVisible(true);
			editor.getSpreadCanvas().imageLabel.moveTo(((Region)bookmark).getCenterPoint());			
			this.setVisible(false);
		}
		ALTERNATE = !ALTERNATE;
	}

}
