/* $Id: BookmarkJumpSelectionListener.java 158 2011-05-08 11:01:20Z ohura $ */
package smart_gs.menu.action;

import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import smart_gs.logical.BookmarkList;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.swingui.WorkspaceWindow;

public class BookmarkJumpSelectionListener extends JFrame 
			implements ListSelectionListener {

	private static boolean ALTERNATE = true;
	private BookmarkList list;

	public BookmarkJumpSelectionListener(BookmarkList list) {
		super("Jump");
		this.list = list;
	}

	@Override
	public void valueChanged(ListSelectionEvent arg0) {
		if (ALTERNATE) {
			BookmarkRegion bookmark = (BookmarkRegion)(list.getSelectedValue());
			Spread spread = bookmark.getSpread();
			WorkspaceWindow.getInstance().setSpread(spread);
			WorkspaceWindow.getInstance().setImageSearch(spread.toString());
			WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.showImage();
			WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.moveTo(((Region)bookmark).getCornerPoint());			
			this.setVisible(false);
		}
		ALTERNATE = !ALTERNATE;
	}

}
