/* $Id: ToolMenu.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import smart_gs.GSConstants;
import smart_gs.dictionary.DictionaryDialog;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.drawing_tool.drawing_mode.BookmarkMode;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.MemoPadMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.logical.Region;
import smart_gs.logical.Sheet;
import smart_gs.logical.SpreadTree;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.menu.action.BookmarkListAction;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.ImageToolBar;

/**
 * 2007/11/1 kazuhiro kobayashi
 * @author Administrator
 *
 */
public class ToolMenu extends JMenu implements ActionListener {

	private JMenuItem select;
	private JMenuItem eraser;
	private JMenuItem rectangle;
	private JMenuItem marker;
	private JMenuItem polygon;
	private JMenuItem memopad;
	private JMenu bookmark;
	private JMenuItem insertBookmark;
	private JMenuItem jumpToBookmark;
	private JMenuItem openBookmark;

	private JMenuItem zoomIn;
	private JMenuItem zoomOut;
	private JMenu showRegion;
	private AbstractGSWindow parent;
	private JMenuItem allRegions;
	private JMenuItem protectedRegions;
	private JMenuItem noRegions;
	private JMenuItem protectAllRegions;
	private JMenuItem releaseAllRegions;

	public ToolMenu(String title, AbstractGSWindow parent) {
		super(title);
		this.parent = parent;

		this.select = new JMenuItem("Select", new ImageIcon(
				GSConstants.ICON_PATH + "select.gif"));
		this.select.addActionListener(this);
		this.add(this.select);

		this.eraser = new JMenuItem("Delete", new ImageIcon(
				GSConstants.ICON_PATH + "delete.gif"));
		this.eraser.addActionListener(this);
		eraser.setAccelerator(KeyStroke.getKeyStroke("ctrl D"));
		this.add(this.eraser);

		this.addSeparator();

		this.rectangle = new JMenuItem("Rectangle");
		this.rectangle.addActionListener(this);
		this.add(this.rectangle);

		this.marker = new JMenuItem("Marker");
		this.marker.addActionListener(this);
		this.add(this.marker);

		this.polygon = new JMenuItem("Polygon");
		this.polygon.addActionListener(this);
		this.add(this.polygon);

		this.memopad = new JMenuItem("MemoPad");
		this.memopad.addActionListener(this);
		this.add(this.memopad);

		
		this.bookmark = new JMenu("Bookmark");
		this.add(this.bookmark);
		this.insertBookmark = new JMenuItem("Insert");
		this.insertBookmark.addActionListener(this);
		bookmark.add(this.insertBookmark);
		this.jumpToBookmark = new JMenuItem("Jump");
		this.jumpToBookmark.addActionListener(this);
		bookmark.add(this.jumpToBookmark);
		this.openBookmark = new JMenuItem("Open");
		this.openBookmark.addActionListener(this);
		bookmark.add(this.openBookmark);

		this.addSeparator();

		this.zoomIn = new JMenuItem("Zoom in", new ImageIcon(
				GSConstants.ICON_PATH + "zoom_in.gif"));
		this.zoomIn.addActionListener(this);
		this.add(this.zoomIn);

		this.zoomOut = new JMenuItem("Zoom out", new ImageIcon(
				GSConstants.ICON_PATH + "zoom_out.gif"));
		this.zoomOut.addActionListener(this);
		this.add(this.zoomOut);

		this.addSeparator();

		this.showRegion = new JMenu("Show Region");
		this.add(this.showRegion);
		
		this.allRegions = new JMenuItem("All Regions");
		this.allRegions.addActionListener(this);
		this.add(this.allRegions);
		
		this.protectedRegions = new JMenuItem("Protected Regions");
		this.protectedRegions.addActionListener(this);
		this.add(this.protectedRegions);
		
		this.noRegions = new JMenuItem("No Regions");
		this.noRegions.addActionListener(this);
		this.add(this.noRegions);
		
		this.showRegion.add(this.allRegions);
		this.showRegion.add(this.protectedRegions);
		this.showRegion.add(this.noRegions);

		// 2010/11 kukita 
		this.protectAllRegions = new JMenuItem("Protect All Regions");
		this.protectAllRegions.addActionListener(this);
		this.add(this.protectAllRegions);
		
		// 2010/11 kukita 
		this.releaseAllRegions = new JMenuItem("Release All Reagions");
		this.releaseAllRegions.addActionListener(this);
		this.add(this.releaseAllRegions);

		this.addSeparator();
		JMenuItem test = new JMenuItem("Dictionary");
		test.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				DictionaryDialog dictionaryDialog = new DictionaryDialog(WorkspaceWindow.getInstance(),"Dictionary",false,0);
				dictionaryDialog.setVisible(true);
			}
		});
		this.add(test);
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this.select)) {
			DefaultState.getInstance()
					.setMode(DefaultDrawingMode.getInstance());
			ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeNone]);
		} else if (e.getSource().equals(this.rectangle)) {
			DefaultState.getInstance().setMode(RectangleMode.getInstance());
			ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeRectangle]);
		} else if (e.getSource().equals(this.marker)) {
			DefaultState.getInstance().setMode(MarkerMode.getInstance());
			ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeMarker]);
		} else if (e.getSource().equals(this.polygon)) {
			DefaultState.getInstance().setMode(PolygonMode.getInstance());
			ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modePolygon]);
		} else if (e.getSource().equals(this.memopad)) {
			DefaultState.getInstance().setMode(MemoPadMode.getInstance());
			ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeMemoPad]);
		} else if (e.getSource().equals(this.insertBookmark)) {
			DefaultState.getInstance().setMode(BookmarkMode.getInstance());
			ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeBookmark]);
		} else if (e.getSource().equals(this.jumpToBookmark) || e.getSource().equals(this.openBookmark)) {
			List<BookmarkRegion> bookmarks = SpreadTree.getInstance().getBookmarks();
			new BookmarkListAction(bookmarks).actionPerformed(e);
			parent.repaint();
		} else if (e.getSource().equals(this.zoomIn)) {
			parent.getSpreadCanvas().zoomIn();
		} else if (e.getSource().equals(this.zoomOut)) {
			parent.getSpreadCanvas().zoomOut();
		} else if (e.getSource().equals(this.eraser)) {
			Region region = UniSelectedState.getInstance().getSelectedRegion();
			new DeleteRegionAction(region).execute();
			parent.repaint();
		} else if (e.getSource().equals(this.allRegions)) {
			ImageToolBar.setShowRegionItem(ImageToolBar.showregionarray[ImageToolBar.showAll]);
			parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_ALL_REGIONS);
			parent.repaint();
		} else if (e.getSource().equals(this.protectedRegions)) {
			ImageToolBar.setShowRegionItem(ImageToolBar.showregionarray[ImageToolBar.showProtected]);
			parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_PROTECTED_REGIONS);
			parent.repaint();
		} else if (e.getSource().equals(this.noRegions)) {
			ImageToolBar.setShowRegionItem(ImageToolBar.showregionarray[ImageToolBar.showNo]);
			parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_NO_REGIONS);
			parent.repaint();
		} else if (e.getSource().equals(this.protectAllRegions)) {
			parent.getSpreadCanvas().protectAllRegions();
		} else if (e.getSource().equals(this.releaseAllRegions)) {
			parent.getSpreadCanvas().releaseAllRegions();
		}
	}
}
