/* $Id: EditorSettingDialog.java 148 2011-05-01 13:25:14Z shayashi $ */
package smart_gs.menu;

import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import smart_gs.logical.Preference;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;

import java.awt.Dimension;

public class EditorSettingDialog extends JDialog {

	private static final long serialVersionUID = 1L;

	private JPanel jContentPane = null;

	private JLabel jLabel = null;

	private JTextField editorPath = null;

	private JButton selectButton = null;

	private JButton okButton = null;

	private JButton cancelButton = null;
	
	private JDialog jDialog;
	
	/**
	 * @param owner
	 */
	public EditorSettingDialog(Frame owner) {
		super(owner,true);
		initialize();
		jDialog = this;
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(504, 108);
		this.setContentPane(getJContentPane());
		this.setTitle("Select Editor");
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jLabel = new JLabel();
			jLabel.setBounds(new Rectangle(14, 11, 43, 16));
			jLabel.setText("Editor");
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(jLabel, null);
			jContentPane.add(getEditorPath(), null);
			jContentPane.add(getSelectButton(), null);
			jContentPane.add(getOkButton(), null);
			jContentPane.add(getCancelButton(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes BrowserPath	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getEditorPath() {
		if (editorPath == null) {
			editorPath = new JTextField();
			editorPath.setBounds(new Rectangle(58, 11, 308, 20));
			if(Preference.getInstance().getInstance().getEditor() != null){
				editorPath.setText(Preference.getInstance().getInstance().getEditor());
			}
		}
		return editorPath;
	}

	/**
	 * This method initializes selectButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getSelectButton() {
		if (selectButton == null) {
			selectButton = new JButton();
			selectButton.setText("select files...");
			selectButton.setBounds(new Rectangle(370, 11, 116, 20));
			selectButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					JFileChooser chooser = new JFileChooser();
					int returnVal = chooser.showOpenDialog(WorkspaceWindow.getInstance());
					try {
						if (returnVal == JFileChooser.APPROVE_OPTION) {
							File file = chooser.getSelectedFile();
							editorPath.setText(CanonicalPathString.get(file));
						}
					} catch(Exception ex){}
				}
			});
		}
		return selectButton;
	}

	/**
	 * This method initializes okButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getOkButton() {
		if (okButton == null) {
			okButton = new JButton();
			okButton.setBounds(new Rectangle(108, 40, 100, 20));
			okButton.setText("OK");
			okButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					String editor = editorPath.getText();
					if(editor != null){
						Preference.getInstance().getInstance().setEditor(editor);
					}
					jDialog.setVisible(false);
				}
			});
		}
		return okButton;
	}

	/**
	 * This method initializes cancelButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getCancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton();
			cancelButton.setBounds(new Rectangle(225, 40, 100, 20));
			
			cancelButton.setText("Cancel");
			cancelButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					jDialog.setVisible(false);
				}
			});
		}
		return cancelButton;
	}
	
}  //  @jve:decl-index=0:visual-constraint="10,10"
