/* $Id: ShowResourceVisitor.java 158 2011-05-08 11:01:20Z ohura $ */
package smart_gs.logical.visitor;

import javax.swing.JOptionPane;

import smart_gs.logical.UsersNote;
import smart_gs.logical.Region;
import smart_gs.logical.SmartDocument;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.IDAT;
import smart_gs.logical.StandardTextDocument;
import smart_gs.logical.TextSegment;
import smart_gs.logical.UsersNoteDirectory;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.smleditor.swingui.GSTextEditor;

public class ShowResourceVisitor implements Visitor{

	public void visit(Spread spread) {
		new GSEditor(spread).setVisible(true);
	}

	public void visit(Region region) {
		new GSEditor(region).setVisible(true);
	}

	public void visit(IDAT iDAT) {
		Spread spread = iDAT.getSpread();
		GSEditor editor = new GSEditor(spread);
		editor.setVisible(true);
	}

	public void visit(TextSegment segment) {
		SmartDocument document = segment.getDocument();
		
		// 20080916 Hashimoto.
		// editor JۂTextSegment Ń}[NAbvꂽӏɃJ[\
		//@ړ悤ɏCB
		int id = segment.getId();
		if(document instanceof IDAT){
			GSEditor editor = new GSEditor(((IDAT)document).getSpread());
			editor.getSMLTabbedPane().setPanelToShow(((IDAT)document).getType());
			editor.updateText();
			editor.setVisible(true);
			editor.emphasize(id +"");
		}else if(document instanceof GSExplanatoryNote){
			((GSExplanatoryNote)document).show();
		}else{
			//2007/11/20 kazuhiro kobayashi
			GSTextEditor editor = new GSTextEditor(document);
			editor.setSize(800,600);
			//2007/12/15 shimizu wrote

			//
			editor.setTitle(document.getName());
			editor.setVisible(true);
			editor.emphasize(id+"");
			//
		}
		
	}

	public void visit(SpreadDirectory directory) {
		JOptionPane.showMessageDialog(null,"No way to show");
		
	}

	public void visit(StandardTextDocument textDocument) {
		new GSTextEditor(textDocument).setVisible(true);
	}

	public void visit(GSExplanatoryNote note) {
		System.out.println("_");
		
//		new ExplanatoryNoteDialog(note).setVisible(true);
	}
	
	//20070923shimizu wrote;
	public void visit(UsersNote usersNote){
		new GSTextEditor(usersNote).setVisible(true);
	}

	// 2011.04.19 shayashi
	@Override
	public void visit(UsersNoteDirectory usersNoteDirectory) {
		JOptionPane.showMessageDialog(null,"No way to show");
		
	}
	

}
