package smart_gs.logical.filter;

import java.io.File;

import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;

// Filter for file chooser
public class ImageFileFilter extends FileFilter {

	@Override
	public boolean accept(File file) {
		String formatNames[] = ImageIO.getReaderFormatNames();
		String fileName = file.getName();
//		files and dirs with forbidden names are invisible
		if(InvisibleName.isInvisible(fileName)){
			return false;
		}
//		directories are not visible.
		if(file.isDirectory()){
			return false;
		}
		for(int i=0;i<formatNames.length;i++){
			if (fileName.endsWith("."+formatNames[i])) return true;
		}
		
		return false;
	}

	@Override
	public String getDescription() {
		// TODO Auto-generated method stub
		return "excludes CVS, DSC and .* (casesenseless)";
	}

}
