/* $Id: Region.java 158 2011-05-08 11:01:20Z ohura $ */
package smart_gs.logical;

import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;



import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.visitor.Visitor;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.ImageCropper;


public class Region extends GSResource{

	protected Spread spread;
	protected View view;
	protected String baseURI;
	public List<Point2D> points;
	/*
	 * regiong@ǂsheetɂ̂͒mȂق̂Ȃ
	 */
//	protected Sheet sheet;
	
//	private boolean isProtected = false;
	//kazuhiro kobayashi 10/7
	private String protection = NORMAL;
	public static final String PROTECTED = "protected";
	public static final String NORMAL = "normal";
	
	private static int id = 1;
 
	
//	public Region(String uri){
//		super(uri);
//	}
	
	 
//	public Region(Spread spread, View view, Sheet sheet){
//		this(spread, view);
//		this.sheet = sheet;
//	}
	public Region(Spread spread,View view){
		super(spread.getURI()+""+view.getTypeString() +"/" +uriExtension());
		baseURI = spread.getURI()+""+view.getTypeString()+"/";
		this.spread = spread;
		this.view = view;
		id++;
		this.setId((id-1));
		WorkspaceWindow.setUpdated(true);
	}
	/*
	 * only for Line Segment
	 * need to be refactored
	 */
	/*
	protected Region(Spread spread){
		super("line segment");
		this.spread = spread;
	}
	*/
	protected Region(Spread spread, String type_name) {
		super(spread.getURI()+ "" + type_name + "/" + uriExtension());
//		baseURI = spread.getURI()+""+view.getTypeString()+"/";
		this.spread = spread;
		id++;
		this.setId((id-1));
		WorkspaceWindow.setUpdated(true);
	}

	public View getView(){
		return this.view;
	}
	public void setView(View view){
		this.view = view;
	}
	public Spread getSpread(){
		return this.spread;
	}
//	public Sheet getSheet(){
//		return this.sheet;
//	}
	public boolean contains(Point2D point){
		return this.view.contains(point);
	}
	@Override
	public JPanel createElementViewPanel() throws NoWayToShowException {
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		Image image = new ImageCropper(this).crop();
		JLabel label = new JLabel();
		if(centermode){
			label.setHorizontalAlignment(JLabel.CENTER);
		}
		ImageIcon icon = new ImageIcon(image);
		label.setIcon(icon);
		panel.add(label,BorderLayout.CENTER);
		return panel;
	}

	protected boolean centermode = false;
	public void setCentermode(boolean centermode) {
		this.centermode = centermode;
	}
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}

	/*
	 * ی샂[hɊւ郁\bhQ
	 */
	
	public void setProtection(String protection){
//		isProtected = true;
		//kazuhiro kobayashi 10/7
		this.protection = protection;
	}
//	public void releaseProtection(){
//		isProtected = false;
//		//kazuhiro kobayashi 10/7
//		this.protection = NORMAL;
//	}
	//kazuhiro kobayashi 10/7
	public String isProtected(){
		return this.protection;
	}
	
	//kazuhiro kobayashi 10/7
	//kazuhiro kobayashi 10/9
//	public String getProtection(){
//		return this.protection;
//	}
	
	// ADD northgrid
	public String getBaseURI(){
		return baseURI;
	}
	public Rectangle getRectangle() {
		return this.view.getRectangle();
	}
	
	public List<Point2D> getPoints(){
		return this.points;
	}

	public Point getCenterPoint() {
		int x = (int)this.getRectangle().getCenterX();
		int y = (int)this.getRectangle().getCenterY();
		return new Point(x, y);
	}

	public Point getCornerPoint() {
		int x = (int)this.getRectangle().getX();
		int y = (int)this.getRectangle().getY();
		return new Point(x, y);
	}
}
