/* $Id: Preference.java 148 2011-05-01 13:25:14Z shayashi $ */
package smart_gs.logical;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

import javax.swing.JOptionPane;

import org.apache.commons.io.FileUtils;

import smart_gs.SmartGS;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.image_search.logical.TextType;

public class Preference {
	
	private static Preference singleton = new Preference();
	
	private String userName;
	//2007/10/7 kazuhiro kobayashi
	private String gsFolderPathString;
	//2007/1010 kazuhiro kobayashi
	/*
	 * ̃t@CpathÕtH_Ɏwł悤ǉ
	 */
	private String imageFolderPathString;
	private String textFolderPathString;
	private String dscFolderPathString;
	private String lineFolderPathString;
	private String smart_gsFolderPathString;
	// ADD NorthGrid
	private String smart_exportFolderPathString;
	//
	private String defaultGsFilePathString;

	//2007/11/20 kazuhiro kobayashi
	private String nameCorrespondenceFilePathString;
	
	//2007/12/8 kazuhiro kobayshi
	private String RWBackgroundFilePathString;
	
	private boolean shouldLoadAll = false;
	// 20090123 NorthGrid
	// 0 = [Jt@C
	// 1 = WebDav
	private int filemode = 0;
	
	// 20090123 NorthGrid
	private String webdavServerPathString;
	private String webdavUserName;
	private String webdavPassword;
	
	// 20090222 NorthGrid
	private String browser;
	// 20090527 NorthGrid
	private String webdavunlock;
	// 20091014 NorthGrid
	private String editor;

	// 20090907 NorthGrid
	private String dictionary;
	private String searchImageDictionaryLogic;
	
	// 20100419 NorthGrid
	private String proxyAddress;
	private String proxyPort;
	
	// 20090422 NorthGrid
	private static String preferenceFile = "preference.xml";
	private static String preferenceDefaultFile = "preference-default.xml";
	
	// 2011.02.20 shayashi
	private String firstIDATName;
	private String secondIDATName;
	private String thirdIDATName;
	
	private Preference(){
		this.userName = "default user";
	}
	
	public static Preference getInstance(){
		return singleton;
	}
	
	public boolean shouldLoadAll(){
		return this.shouldLoadAll;
	}
	public void setShouldLoadAll(boolean shouldLoadAll) {
		this.shouldLoadAll = shouldLoadAll;
	}
	
	public String getUserName(){
		return this.userName;
	}
	public void setUserName(String userName){
		this.userName = userName;
	}
	
	// 2011.02.20 shayashi
	public String getFirstIDATName() {
		return firstIDATName;
	}	
	public void setFirstIDATName(String name) {
		firstIDATName = name;
	}
	public String getSecondIDATName() {
		return secondIDATName;
	}	
	public void setSecondIDATName(String name) {
		secondIDATName = name;
	}
	public String getThirdIDATName() {
		return thirdIDATName;
	}	
	public void setThirdIDATName(String name) {
		thirdIDATName = name;
	}
	

	public void load(){
		try {
			Properties properties = new Properties();

			File file = new File(preferenceFile);
			if(!file.exists()) {
				File defaultFile = new File(preferenceDefaultFile);
				FileUtils.copyFile(defaultFile, file);
			}
			FileInputStream inStream = new FileInputStream(file);
			properties.loadFromXML(inStream);
			//
			this.userName = properties.getProperty("userName");
			if(this.userName == "") {
				this.userName = JOptionPane.showInputDialog("SMART-GS: Please enter your name", this.userName);
				Preference.getInstance().getInstance().setUserName(this.userName);
			}
			int max = new Integer(properties.getProperty("search_max"));
			GSSearchEngine.getInstance().setMaxFound(max);
			
			//20090118 North Grid add
			String searchEngineString = properties.getProperty("image_seatch_engine");
			int searchEngine = searchEngineString == null ? 0 : new Integer(searchEngineString);
			if( searchEngine == 0 ){
				GSSearchEngine.getInstance().setUseExternalEngine(true);
			}else{
				GSSearchEngine.getInstance().setUseExternalEngine(false);
			}
			
			//20080715 shimizu wrote
			int searchType = new Integer(properties.getProperty("search_type"));
			GSSearchEngine.getInstance().setSearchType(searchType);
			int textType = new Integer(properties.getProperty("text_type"));
			TextType.setTextType(textType);
			//2007/10/7 kazuhiro kobayashi
			this.gsFolderPathString = properties.getProperty("gsFolderPath");
			//2007/10/10n kazuhiro kobayashi
			this.imageFolderPathString = properties.getProperty("imageFolderPath");
			this.textFolderPathString = properties.getProperty("textFolderPath");
			this.dscFolderPathString = properties.getProperty("dscFolderPath");
			this.lineFolderPathString = properties.getProperty("lineFolderPath");
			//2007/10/11
			this.smart_gsFolderPathString = properties.getProperty("smart_gsFolderPath");
			// ADD NorthGrid
			this.smart_exportFolderPathString = properties.getProperty("smart_exportFolderPath");
			//2007/11/20 kazuhiro kobayashi
			this.nameCorrespondenceFilePathString = properties.getProperty("nameCorrespondenceFilePath");
			//2007/11/27 kazuhiro kobayshi
			this.defaultGsFilePathString = properties.getProperty("defaultGsFilePath");
			//2007/12/8 kazuhiro kobayshi
			this.RWBackgroundFilePathString = properties.getProperty("RWBackgroundFilePath");
			// 2009/01/23 NorthGrid
			try{
				this.filemode = Integer.parseInt(properties.getProperty("file_mode"));
			}catch(NumberFormatException e){}
			
			this.webdavServerPathString = properties.getProperty("WebDavServerPath");
			this.webdavUserName   = properties.getProperty("WebDavUserName");
			this.webdavPassword   = properties.getProperty("WebDavPassword");
			
			this.browser = properties.getProperty("browser");
			
			this.editor = properties.getProperty("editor");

			this.webdavunlock = properties.getProperty("WebDavUnlock");
			if(webdavunlock == null){
				webdavunlock = "1";
			}
			this.dictionary = properties.getProperty("Dictionary");
			if(this.dictionary == null){
				this.dictionary = "./dictionary.xml";
			}
			this.searchImageDictionaryLogic = properties.getProperty("SearchLogic");
			if(searchImageDictionaryLogic == null){
				searchImageDictionaryLogic = "0";
			}
			
			// 2011.02.20 shayashi
			this.firstIDATName = properties.getProperty("firstIDATName");
			if(firstIDATName == null){
				firstIDATName = "Note1";
			}
			this.secondIDATName = properties.getProperty("secondIDATName");
			if(secondIDATName == null){
				secondIDATName = "Note2";
			}
			this.thirdIDATName = properties.getProperty("thirdIDATName");
			if(thirdIDATName == null){
				thirdIDATName = "Note3";
			}
			
			// 2010/04/19
			this.proxyAddress = properties.getProperty("ProxyAddress");
			this.proxyPort    = properties.getProperty("ProxyPort");

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
	}
	public void save() {
		Properties properties = new Properties();
		properties.put("userName", this.userName);
		int max = GSSearchEngine.getInstance().getMaxFound();
		properties.put("search_max",max+"");

		//20090118 North Grid add
		if( GSSearchEngine.getInstance().isUseExternalEngine() ){
			properties.put("image_seatch_engine","0");
		}else{
			properties.put("image_seatch_engine","1");
		}
		
		int searchType = GSSearchEngine.getInstance().getSearchType();
		properties.put("search_type",searchType+"");
		//20080715 shimizu wrote
	    int textType = TextType.getTextType();
		properties.put("text_type", textType+"");
		//2007/10/7 kazuhiro kobayashi
		if(this.gsFolderPathString!=null){
			properties.put("gsFolderPath", this.gsFolderPathString);
		}
		//2007/10/10 kazuhiro kobayashi
		if(this.imageFolderPathString!=null){
			properties.put("imageFolderPath", this.imageFolderPathString);
		}
		if(this.textFolderPathString!=null){
			properties.put("textFolderPath", this.textFolderPathString);
		}
		if(this.dscFolderPathString!=null){
			properties.put("dscFolderPath", this.dscFolderPathString);
		}
		if(this.lineFolderPathString!=null){
			properties.put("lineFolderPath", this.lineFolderPathString);
		}
		//2007/10/11
		if(this.smart_gsFolderPathString!=null){
			properties.put("smart_gsFolderPath", this.smart_gsFolderPathString);
		}
		//2007/11/20 kazuhiro kobayashi
//		if(this.nameCorrespondenceFilePath!=null){
			properties.put("nameCorrespondenceFilePath", this.nameCorrespondenceFilePathString);
//		}
		//2007/11/27 kazuhiro kobayashi
//		if(this.defaultGsFilePath!=null){
			properties.put("defaultGsFilePath", this.defaultGsFilePathString);
//		}
			//2007/12/8 kazuhiro kobayshi
			properties.put("RWBackgroundFilePath", this.RWBackgroundFilePathString);
		
		// 2009/01/23 NorthGrid
		properties.put("file_mode", String.valueOf(this.filemode));
		if(webdavServerPathString != null){
			properties.put("WebDavServerPath", webdavServerPathString);
		}
		if(webdavUserName != null){
			properties.put("WebDavUserName", webdavUserName);
		}
		if(webdavPassword != null){
			properties.put("WebDavPassword", webdavPassword);
		}
		if(this.browser != null){
			properties.put("browser", browser);
		}
		if(this.editor != null){
			properties.put("editor", editor);
		}
		if(this.webdavunlock != null){
			properties.put("WebDavUnlock", webdavunlock);
		}
		if(this.dictionary != null){
			properties.put("Dictionary", dictionary);
		}
		if(this.searchImageDictionaryLogic != null){
			properties.put("SearchLogic", searchImageDictionaryLogic);
		}
		// 20100419
		if(proxyAddress != null){
			properties.put("ProxyAddress", proxyAddress);
		}
		if(proxyPort != null){
			properties.put("ProxyPort", proxyPort);
		}
//		2011.02.23 shayashi
		if(firstIDATName != null){
			properties.put("firstIDATName", firstIDATName);
		}
		if(secondIDATName != null){
			properties.put("secondIDATName", secondIDATName);
		}
		if(thirdIDATName != null){
			properties.put("thirdIDATName", thirdIDATName);
		}
		try {
//			
//			FileOutputStream outStream = new FileOutputStream(new File("preference.txt"));
//			properties.store(outStream,"no comment");
			FileOutputStream outStream = new FileOutputStream(new File(preferenceFile));
			properties.storeToXML(outStream,"no comment");
			//		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		// 20090907
		

	}
	//2007/10/7 kazuhiro kobayashi
	public String getGsFolderPathString(){
		return this.gsFolderPathString;
	}
	public void setGsFolderPathString(String gsFolderPathString){
		this.gsFolderPathString = gsFolderPathString;
	}
	// ADD NorthGrid
	public String getSmart_exportFolderPathString() {
		return smart_exportFolderPathString;
	}

	public void setSmart_exportFolderPathString(String smart_exportFolderPathString) {
		this.smart_exportFolderPathString = smart_exportFolderPathString;
	}
	
	
	//2007/10/11 kazuhiro kobayashi
	public String getImageFolderPathString() {
		return imageFolderPathString;
	}

	public void setImageFolderPathString(String imageFolderPathString) {
		
		if(imageFolderPathString != null){
			this.imageFolderPathString = imageFolderPathString ;
		}
	}

	public String getTextFolderPathString() {
		return textFolderPathString;
	}

	public void setTextFolderPathString(String textFolderPathString) {
		if(textFolderPathString != null){
			this.textFolderPathString = textFolderPathString ;
		}
	}

	public String getDscFolderPathString() {
		return dscFolderPathString;
	}

	public void setDscFolderPathString(String dscFolderPathString) {
		if(dscFolderPathString != null){
				this.dscFolderPathString = dscFolderPathString ;
		}
	}

	public String getLineFolderPathString() {
		return lineFolderPathString;
	}

	public void setLineFolderPathString(String lineFolderPathString) {
		if(lineFolderPathString != null){
				this.lineFolderPathString = lineFolderPathString ;
		}
	}
	//2007/11/20 kazuhiro kobayashi
	public void setNameCorrespondencePathString(String nameCorrespondencePathString){
//		if(nameCorrespondencePath!=null){
			this.nameCorrespondenceFilePathString = nameCorrespondencePathString;
//		}
	}
	public String getNameCorrespondencePath(){
		return this.nameCorrespondenceFilePathString;
	}
	public void setSmart_gsFolderPathString(String smart_gsFolderPathString){
		this.smart_gsFolderPathString = smart_gsFolderPathString;
	}
	public String getSmart_gsFolderPathString(){
		return this.smart_gsFolderPathString;
	}
	//2007/11/27 kazuhiro kobayashi
	public String getDefaultGsFilePathString() {
		return defaultGsFilePathString;
	}
	public void setDefaultGsFilePath(String defaultGsFolePathString) {
		this.defaultGsFilePathString = defaultGsFolePathString;
	}

	//2007/12/8 kazuhiro kobayshi
	public String getRWBackgroundFilePathString() {
		return RWBackgroundFilePathString;
	}

	public void setRWBackgroundFilePathString(String backgroundFilePathString) {
		RWBackgroundFilePathString = backgroundFilePathString;
	}

	// 2009/01/23 NorthGrid
	public int getFilemode() {
		return filemode;
	}

	public void setFilemode(int filemode) {
		this.filemode = filemode;
	}

	public String getWebdavPassword() {
		return webdavPassword;
	}

	public void setWebdavPassword(String webdavPassword) {
		this.webdavPassword = webdavPassword;
	}

	public String getWebdavServerPathString() {
		return webdavServerPathString;
	}

	public void setWebdavServerPathString(String webdavServerPathString) {
		this.webdavServerPathString = webdavServerPathString;
	}

	public String getWebdavUserName() {
		return webdavUserName;
	}

	public void setWebdavUserName(String webdavUserName) {
		this.webdavUserName = webdavUserName;
	}

	public String getBrowser() {
		return browser;
	}

	public void setBrowser(String browser) {
		this.browser = browser;
	}

	public String getEditor() {
		return editor;
	}

	public void setEditor(String editor) {
		this.editor = editor;
	}

	public static String getPreferenceFile() {
		return preferenceFile;
	}

	public static void setPreferenceFile(String preferenceFile) {
		Preference.preferenceFile = preferenceFile;
	}

	public String getWebdavunlock() {
		return webdavunlock;
	}

	public String getDictionary() {
		return dictionary;
	}

	public void setDictionary(String dictionary) {
		this.dictionary = dictionary;
	}

	public String getSearchImageDictionaryLogic() {
		return searchImageDictionaryLogic;
	}

	public void setSearchImageDictionaryLogic(String searchImageDictionaryLogic) {
		this.searchImageDictionaryLogic = searchImageDictionaryLogic;
	}

	public String getProxyAddress() {
		return proxyAddress;
	}

	public void setProxyAddress(String proxyAddress) {
		this.proxyAddress = proxyAddress;
	}

	public String getProxyPort() {
		return proxyPort;
	}

	public void setProxyPort(String proxyPort) {
		this.proxyPort = proxyPort;
	}
}
