/* $Id: GSResource.java 158 2011-05-08 11:01:20Z ohura $ */
package smart_gs.logical;


import javax.swing.JPanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import reasoning_web.logical.NotMarkupException;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.logical.visitor.Acceptor;
import smart_gs.logical.visitor.CreateXMLElementVisitor;
import smart_gs.logical.visitor.ShowResourceVisitor;
import smart_gs.logical.visitor.Visitor;
import smart_gs.reasoning_web.logical.GS_RWElement;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;

public abstract class GSResource implements GS_RWElement,Acceptor{

	protected String uri;
	protected String name;
	protected int id;

	//2011/01/06 kukita
	protected static final String ANONYMOUS_USER = "0000000000000000";
	private static String LAST_CREATED_TIME;
	private static int ADDITIONAL_EXTENSION;

	public static final String NAME = "name";
	public static final String ID = "id";
	public static final String URI = "uri";

//	2011.03.29 shayashi deleted
//	//2007/11/20 kazuhiro kobayashi
//	protected String userName;
//	protected String systemName;
//	//

	//	public GSResource(){
	//		
	//	}
	public GSResource(String uri){
		this.uri = uri;
		this.name = "";
		this.id = this.hashCode() % 1000;
	}

	public void setId(int id) {
		this.id = id;
	}
	public int getId() {
		return id;
	}
	public String getURI(){
		return this.uri;
	}	
	public void setURI(String uri){
		this.uri = uri;
	}
	public void extendUriBy(String extension) {
		this.uri = this.uri + extension;
	}// 2011/01/19 kukita
	public void extendUriBy(int extension) {
		this.uri = this.uri + extension;
	}// 2011/01/19 kukita
	public String getName(){
		return this.name;
	}
	public void setName(String name){
		this.name = name;
	}

	public final void show() {
		ShowResourceVisitor visitor = new ShowResourceVisitor();
		this.accept(visitor);
	}
	public String getSource() throws NotMarkupException{
		throw new NotMarkupException();
	}
	public JPanel createElementViewPanel() throws NoWayToShowException {
		throw new NoWayToShowException();
	}
	@Override
	public String toString() {
		return this.uri;
		//		return this.name;
	}
	public final Element createXMLElement(Document document){
		CreateXMLElementVisitor visitor = new CreateXMLElementVisitor(document);
		this.accept(visitor);
		return visitor.getLastElement();
	}

	public abstract void accept(Visitor visitor);

//	2011.03.28 shayashi deleted
//	//2007/11/20 kazuhiro kobayashi
//	/**
//	 * Stringz󂯂āAsystemNamev̂userNameݒ肷B
//	 */
//	public void setUserName(String[] names){
//		if(names[0].equals(this.systemName)){
//			this.userName = names[1];
//		}
//	}

	//2010/11/06 kukita
	protected static String uriExtension(){
		String time  = createdTime();
		String add_ext = additionalExtension(time);
		LAST_CREATED_TIME = time;
		String name = Preference.getInstance().getInstance().getUserName();
		if (name == null || name == "") {
			return ANONYMOUS_USER +"."+ time + add_ext + "/";
		} else {
			return modifyUserName(name) +"."+ time + add_ext + "/";
		}
	}
	//2011/01/24 kukita
	protected static String additionalExtension(String created_time) {
		String s = "";
		if (created_time.equals(LAST_CREATED_TIME)) {
			ADDITIONAL_EXTENSION++;
			s = "_" + Integer.toString(ADDITIONAL_EXTENSION);
		} else {
			ADDITIONAL_EXTENSION = 0;
		}
		return s;
	}
	//2011/01/24 kukita
	protected static String createdTime() {
		Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
		cal.setTime(new Date());
		String y = Integer.toString(cal.get(Calendar.YEAR));
		String m = adjust(cal.get(Calendar.MONTH) + 1);
		String d = adjust(cal.get(Calendar.DATE));
		String h = adjust(cal.get(Calendar.HOUR_OF_DAY));
		String min = adjust(cal.get(Calendar.MINUTE));
		String sec = adjust(cal.get(Calendar.SECOND));
		//String ms = cal.get(Calendar.MILLISECOND);
		return y + m + d + h + min + sec;
	}
	private static String adjust(int x) {
		if (x < 10) {
			return "0" + Integer.toString(x);
		} else {
			return Integer.toString(x);
		}
	}
	private static String modifyUserName(String name) {
		return name.replace(" ", "?");
	}
	
}
