/* $Id: SearchMenuBar.java 148 2011-05-01 13:25:14Z shayashi $ */
package smart_gs.image_search.normal.swingui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

@SuppressWarnings("serial")
public class SearchMenuBar extends JMenuBar {
	private final int VIEW = 0;

	private final int NEW_RESULT = 0;
	private final int ALL_RESULT = 1;

	private final int OPTION = 1;
	private final int CONTEXT = 0;

	private final int LINE = 1;
	private final int SEGMENT = 2;
	
	private Image queryImage;

	private int[] viewMode = { ALL_RESULT, SEGMENT };

	public SearchMenuBar(final SearchResultViewer parent) {

		// getting query image dimensions
		queryImage = parent.getQueryImage();
		int queryWidth = queryImage.getWidth(null);
		int queryHeight = queryImage.getHeight(null);
		/*
		 * Vʂ邩SČ邩̃j[̒ǉ
		 */
		JMenu view = new JMenu("View");
		JMenuItem newResult = new JMenuItem("New Results Only");
		newResult.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
			AbstractSearchResultPanel resultPanel;
			switch (viewMode[OPTION]) {
			case CONTEXT:
			    resultPanel = new SearchResultPanelContextMode(parent, parent.getNewResults(),queryImage);
			    break;
			case LINE:
			    resultPanel = new SearchResultPanel(parent, parent.getNewResults(),queryImage);
			    break;
			default:
			    resultPanel = new SearchResultPanelSegmentMode(parent, parent.getNewResults(),queryImage);
			    break;
			}
			viewMode[VIEW] = NEW_RESULT;
			parent.setResultPanel(resultPanel);
			parent.validate();
		    }
		});
		JMenuItem allResult = new JMenuItem("All Results");
		allResult.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
			AbstractSearchResultPanel resultPanel;
			switch (viewMode[OPTION]) {
			case CONTEXT:
			    resultPanel = new SearchResultPanelContextMode(parent, parent.getResults(),queryImage);
			    break;
			case LINE:
			    resultPanel = new SearchResultPanel(parent, parent.getResults(),queryImage);
			    break;
			default:
			    resultPanel = new SearchResultPanelSegmentMode(parent, parent.getResults(),queryImage);
			    break;
			}
			viewMode[VIEW] = ALL_RESULT;
			parent.setResultPanel(resultPanel);
			parent.validate();
			
		    }
		});
		view.add(newResult);
		view.add(allResult);
		
		JMenu options = new JMenu("Option");
		JMenu mode = new JMenu("Display Mode");
		options.add(mode);
		JMenuItem context = new JMenuItem("Context Mode");
		context.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
//				AbstractSearchResultPanel resultPanel = new SearchContextPanel(
//						parent, parent.getResults());
				/*
				 * j[ɂ\̐؂ւ
				 */
				AbstractSearchResultPanel resultPanel;
				switch (viewMode[VIEW]) {
				case NEW_RESULT:
				    resultPanel = new SearchResultPanelContextMode(parent,parent.getNewResults(),queryImage);
				    break;
				default:
				    resultPanel = new SearchResultPanelContextMode(parent,parent.getResults(),queryImage);
				    break;
				}
				viewMode[OPTION] = CONTEXT;
				
				
				parent.setResultPanel(resultPanel);
				parent.validate();
			}
		});
		JMenuItem line = new JMenuItem("Line Mode");
		line.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
//				AbstractSearchResultPanel resultPanel = new SearchResultPanel(
//						parent, parent.getResults());
				/*
				 * ؂ւ
				 */
				AbstractSearchResultPanel resultPanel;
				switch (viewMode[VIEW]) {
				case NEW_RESULT:
				    resultPanel = new SearchResultPanel(parent,parent.getNewResults(),queryImage);
				    break;
				default:
				    resultPanel = new SearchResultPanel(parent,parent.getResults(),queryImage);
				    break;
				}
				viewMode[OPTION] = LINE;
				
				
				parent.setResultPanel(resultPanel);
				parent.validate();
			}
		});
		JMenuItem segment = new JMenuItem("Segment Mode");
		segment.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
//				AbstractSearchResultPanel resultPanel = new SearchResultListPanel(
//						parent, parent.getResults());
				

				AbstractSearchResultPanel resultPanel;
				switch (viewMode[VIEW]) {
				case NEW_RESULT:
				    resultPanel = new SearchResultPanelSegmentMode(parent,parent.getNewResults(),queryImage);
				    break;
				default:
				    resultPanel = new SearchResultPanelSegmentMode(parent,parent.getResults(),queryImage);
				    break;
				}
				viewMode[OPTION] = SEGMENT;
				
				
				parent.setResultPanel(resultPanel);
				parent.validate();
			}
		});
		mode.add(context);
		mode.add(line);
		mode.add(segment);


		this.add(view);
		this.add(options);
	}

}
