/* $Id: GSQuery.java 158 2011-05-08 11:01:20Z ohura $ */
package smart_gs.image_search.logical;

import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import reasoning_web.logical.NotMarkupException;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSConstants;
import smart_gs.logical.Spread;
import smart_gs.logical.URISolver;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.util.BmpFileCreator;
import smart_gs.util.CanonicalPathString;

import image_search.Query;

public class GSQuery extends Query implements GS_RWElement{
	
	protected Spread spread = null;
	protected String name = "";
	
	public GSQuery(Spread spread,File dscFile, Rectangle rectangle) {
		super(spread.getImage(),dscFile, rectangle);
		this.spread = spread;
	}
	public GSQuery(Image image,File dscFile,Rectangle rectangle){
		super(image,dscFile,rectangle);
	}
	public GSQuery(Spread spread,Image image,File dscFile,Rectangle rectangle){
		super(image,dscFile,rectangle);
		this.spread = spread;
	}
	public Spread getSpread(){
		return this.spread;
	}
	public boolean hasSpread(){
		if(this.spread == null){
			return false;
		}else{
			return true;
		}
	}
	public JPanel createElementViewPanel() throws NoWayToShowException {
		JLabel label = new JLabel(new ImageIcon(this.getQueryImage()));
		JPanel panel = new JPanel();
		panel.add(label);
		return panel;
	}
	public String getSource() throws NotMarkupException {
		//vC
		return "<xml><query/></xml>";
	}
	public void show() {
		if(this.spread != null){
			new GSEditor(this.spread,this.getRectangle()).setVisible(true);
		}else{
			JOptionPane.showMessageDialog(null,"can't jump to edited image");
		}
	}
	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getURI(){
		return GSConstants.URI_HEADER+"query/"+this.name;
	}
	public Element createXMLElement(Document document) {
		Element element = document.createElement("query");
		element.setAttribute("hasSpread",this.hasSpread()+"");
		element.setAttribute("name",this.name);
		if( this.dscFile != null ){
			element.setAttribute("dscfile",CanonicalPathString.get(this.dscFile));
		}
		if(this.hasSpread()){
			element.setAttribute("spreadURI",this.spread.getURI());
		}else{
			//edited image̕ۑ
			BmpFileCreator creator = new BmpFileCreator(this.image,this.rectangle.width,this.rectangle.height);
			int id = this.hashCode();
			creator.create("temp/",id+".bmp",false);
			element.setAttribute("imagePath","temp/"+id+".bmp");
		}
		element.setAttribute("x",this.rectangle.x+"");
		element.setAttribute("y",this.rectangle.y+"");
		element.setAttribute("width",this.rectangle.width+"");
		element.setAttribute("height",this.rectangle.height+"");
		return element;
	}
	
	public GSQuery getQuery(Element element){
		boolean hasSpread = new Boolean(element.getAttribute("hasSpread"));
		String spreadURI = null;
		String name = element.getAttribute("name");
		if(hasSpread){
			spreadURI = element.getAttribute("spreadURI");
		}
		int x = new Integer(element.getAttribute("x"));
		int y = new Integer(element.getAttribute("y"));
		int width = new Integer(element.getAttribute("width"));
		int height = new Integer(element.getAttribute("height"));
		
		GSQuery query = null;
		if(hasSpread){
			Spread spread = (Spread)URISolver.getResource(spreadURI);
			query = new GSQuery(spread,spread.getDscFile(),new Rectangle(x,y,width,height));
			query.setName(name);
		}else{
			String dscFilePath = element.getAttribute("dscfile");
			String imagePath = element.getAttribute("imagePath");
			
			Image image = null;
			try {
				
				image = ImageIO.read(new File(imagePath));
				System.out.println("image :: "+image);
			} catch (IOException e) {
				e.printStackTrace();
			}
			
			File dscFile = new  File(dscFilePath);
			query = new GSQuery(image,dscFile,new Rectangle(x,y,width,height));
			query.setName(name);
		}
		return query;
	}
}
