/* $Id: LineView.java 158 2011-05-08 11:01:20Z ohura $ */
package smart_gs.drawing_tool.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import smart_gs.drawing_tool.ExLine2D;
import smart_gs.logical.LineSegment;


public class LineView extends View{

	protected ExLine2D line;
	private int breadth;
	
	public LineView(Point2D start,Point2D end){
		super();
		this.line = new ExLine2D(start,end);
		this.defaultColor = Color.BLUE;
		this.selectionColor = Color.red;
	}

	public LineView(ExLine2D line){
		super();
		this.line = line;
		this.defaultColor = Color.BLUE;
		this.selectionColor = Color.red;
	}
	@Override
	public boolean contains(Point2D point) {
		return this.line.contains(point);
	}

	@Override
	public void drawShape(Graphics2D g) {
		g.draw(this.line);
	}

	@Override
	public int getType() {
		return View.LINE;
	}
	public ExLine2D getLine(){
		return this.line;
	}
	@Override
	public void moveBy(Point2D d) {
		Point2D start = this.line.getP1();
		Point2D end = this.line.getP2();
		start = new Point2D.Double(start.getX()+d.getX(),start.getY()+d.getY());
		end = new Point2D.Double(end.getX()+d.getX(),end.getY()+d.getY());
		this.line = new ExLine2D(start,end);
	}

	@Override
	public View enlargedView(double ratio, double gapX, double gapY) {
		Point2D start = this.line.getP1();
		Point2D end = this.line.getP2();
		Point2D p1 = new Point2D.Double(start.getX()*ratio+gapX,start.getY()*ratio+gapY);
		Point2D p2 = new Point2D.Double(end.getX()*ratio+gapX,end.getY()*ratio+gapY);
		return new LineView(new ExLine2D(p1,p2));
	}
	public double getMinX(){
		Point2D p1 = this.line.getP1();
		Point2D p2 = this.line.getP2();
		double minX = Math.min(p1.getX(),p2.getX());
		return minX;
	}
	public double getMaxX(){
		Point2D p1 = this.line.getP1();
		Point2D p2 = this.line.getP2();
		double maxX = Math.max(p1.getX(),p2.getX());
		return maxX;
	}
	public double getMinY(){
		Point2D p1 = this.line.getP1();
		Point2D p2 = this.line.getP2();
		double minY = Math.min(p1.getY(),p2.getY());
		return minY;
	}
	public double getMaxY(){
		Point2D p1 = this.line.getP1();
		Point2D p2 = this.line.getP2();
		double maxY = Math.max(p1.getY(),p2.getY());
		return maxY;
	}
	@Override
	public Rectangle2D getRectangle2D() {
		Point2D p1 = this.line.getP1();
		Point2D p2 = this.line.getP2();
		double minX = Math.min(p1.getX(),p2.getX());
		double minY = Math.min(p1.getY(),p2.getY());
		double maxX = Math.max(p1.getX(),p2.getX());
		double maxY = Math.max(p1.getY(),p2.getY());
		return new Rectangle2D.Double(minX,minY,maxX-minX,maxY-minY);
	}
	@Override
	public String getTypeString() {
		return "line";
	}
	@Override
	public void drawLinkedShape(Graphics2D g) {
		Stroke stroke = g.getStroke();
		Color oldColor = g.getColor();
		g.setStroke(new BasicStroke(2));
		g.setColor(Color.BLUE);
		g.draw(this.line);
		g.setColor(oldColor);
		g.setStroke(stroke);
	}
	@Override
	public Element createXMLElement(Document document) {
		Element element = document.createElement("view");
		element.setAttribute("type","line");
		element.setAttribute("x1",this.line.x1+"");
		element.setAttribute("y1",this.line.y1+"");
		element.setAttribute("x2",this.line.x2+"");
		element.setAttribute("y2",this.line.y2+"");	
		return element;
	}
	public static LineView restore(Element elem) {
		double x1 = new Double(elem.getAttribute("x1"));
		double y1 = new Double(elem.getAttribute("y1"));
		double x2 = new Double(elem.getAttribute("x2"));
		double y2 = new Double(elem.getAttribute("y2"));
		return new LineView(new ExLine2D(x1,y1,x2,y2));
	}

	@Override
	public Point getCenterPoint() {
		int startX = (int)this.line.getP1().getX();
		int startY = (int)this.line.getP1().getY();
		int endX = (int)this.line.getP2().getX();
		int endY = (int)this.line.getP2().getY();
		return new Point((int)((startX + endX)/2), (int)((startY + endY)/2));
	}
}