/* $Id: WebDavChooser.java 125 2011-03-09 09:49:51Z ohura $ */
package webdav;

import javax.swing.SwingUtilities;
import java.awt.BorderLayout;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.GridBagLayout;
import java.awt.Toolkit;

import javax.swing.JScrollPane;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Stack;

import javax.swing.JTable;
import javax.swing.JButton;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

import org.apache.commons.httpclient.protocol.Protocol;

import smart_gs.logical.Preference;

import webdav.table.PropFindSort;
import javax.swing.JTextField;
import javax.swing.JLabel;

public class WebDavChooser extends JDialog {

	private static final long serialVersionUID = 1L;

	private JPanel jContentPane = null;

	private JScrollPane jScrollPane = null;

	private JTable jTable = null;

	private JButton jButton = null;

	private JButton jButton1 = null;

	private JDialog myJDialog;
	
	private WebDavDownLoadEvent webDavDownLoadEvent;
	private WebDavUploadLoadEvent webDavUploadLoadEvent;  //  @jve:decl-index=0:
	
	private int mode = 0;
	private String owner;

	protected WebDavProcessor webDavProcessor;  //  @jve:decl-index=0:
    protected WebDavViewTableFactory webDavViewTableFactory;  //  @jve:decl-index=0:

	private JButton jButton2 = null;

	private JTextField filenameField = null;

	private JLabel jLabel = null;

	private Stack stack = null;
	private String startpath = null;
	private boolean error = false;
	private boolean cancel = false;

	private JButton jButton3 = null;
	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setBounds(new Rectangle(27, 13, 599, 255));
			jScrollPane.setViewportView(getJTable());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jTable	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getJTable() {
		if (jTable == null) {
			jTable = new JTable();
			
			PropFindInfo[] propFindInfoChild = null;
			try{
				PropFindInfo[] propFindInfo;
				if(startpath != null){
					propFindInfo = webDavProcessor.getPropFindInfo(startpath, 0);
				}else{
					propFindInfo = webDavProcessor.getPropFindInfo("", 0);
				}
				try{
					propFindInfoChild = webDavProcessor.getPropFindInfo(propFindInfo[0].getPath(), 1);
					propFindInfoChild = new PropFindSort().sort(propFindInfoChild);
					if(stack != null){
						if(stack.size() >= 1){
							PropFindInfo[] propFindInfoChildTemp = new PropFindInfo[propFindInfoChild.length + 1];
							{	        					
								PropFindInfo propFindInfoUp = new PropFindInfo();
								propFindInfoUp.setDisplayname("..");
								propFindInfoUp.setDirectory(true);
								propFindInfoChildTemp[0] = propFindInfoUp;
								for(int i=0;i<propFindInfoChild.length;i++){
									propFindInfoChildTemp[i + 1] = propFindInfoChild[i]; 
								}
								propFindInfoChild = propFindInfoChildTemp;
							}
						}
					}
				}catch(Exception ex){
					ex.printStackTrace();
				}
			}catch(Exception e){
				e.printStackTrace();
			}
			webDavViewTableFactory = new WebDavViewTableFactory(mode,propFindInfoChild,Color.WHITE);
			webDavViewTableFactory.setWebDavProcessor(webDavProcessor);
			webDavViewTableFactory.setWebDavDownLoadEvent(webDavDownLoadEvent);
			webDavViewTableFactory.seWebDavUploadLoadEvent(webDavUploadLoadEvent);
			webDavViewTableFactory.setOwner(owner);
			webDavViewTableFactory.setFilenameField(getFilenameField());
			if(stack != null){
				webDavViewTableFactory.setStack(stack);
			}
			jTable = webDavViewTableFactory.getJTable();
		}
		return jTable;
	}

	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton() {
		if (jButton == null) {
			jButton = new JButton();
			jButton.setBounds(new Rectangle(390, 272, 110, 30));
			if(mode == 0){
				jButton.setText("Open");
				jButton.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent e) {
						webDavViewTableFactory.downlaod();
					}
				});
			}else{
				jButton.setText("Save");
				jButton.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent e) {
						webDavViewTableFactory.upload();
					}
				});
			}
		}
		return jButton;
	}

	/**
	 * This method initializes jButton1	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton1() {
		if (jButton1 == null) {
			jButton1 = new JButton();
			jButton1.setBounds(new Rectangle(506, 272, 110, 30));
			jButton1.setText("Cancel");
			jButton1.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					cancel = true;
					myJDialog.setVisible(false);
				}
			});
		}
		return jButton1;
	}

	/**
	 * This method initializes jButton2	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton2() {
		if (jButton2 == null) {
			jButton2 = new JButton();
			jButton2.setBounds(new Rectangle(506, 306, 110, 30));
			jButton2.setText("Unlock");
			jButton2.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					webDavViewTableFactory.unlock();
				}
			});
		}
		return jButton2;
	}

	/**
	 * This is the default constructor
	 */
	public WebDavChooser(Frame frame,int mode,String owner,Stack stack,String startpath) {
		super(frame,true);
		myJDialog = this;
		this.mode = mode;
		this.owner = owner;
		this.stack = stack;
		this.startpath = startpath;
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		webDavProcessor = WebDavProcessor.getInstance();
		if(webDavProcessor == null){
        	JOptionPane.showMessageDialog(
					new JFrame() , "It failed in login to WebDAV." , "fatal" ,
					JOptionPane.ERROR_MESSAGE
				);
        	this.setVisible(false);
        	error = true;
        	return;
		}
		webDavDownLoadEvent = new WebDavDownLoadEvent(this);
		this.setSize(659, 376);
		this.setContentPane(getJContentPane());
		if(mode == 0){
			this.setTitle("Open from WebDAV");
		}else{
			this.setTitle("Save to WebDAV");
		}
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(getJScrollPane(), null);
			jContentPane.add(getJButton(), null);
			jContentPane.add(getJButton1(), null);
			String unlockStr = Preference.getInstance().getInstance().getWebdavunlock();
			if(unlockStr != null){
				if(unlockStr.equals("1")){
					jContentPane.add(getJButton2(), null);
				}
			}
			jContentPane.add(getJButton3(), null);
			if(getFilenameField() != null){
				jContentPane.add(getFilenameField(), null);
				jLabel = new JLabel();
				jLabel.setBounds(new Rectangle(51, 278, 61, 27));
				jLabel.setText("file name");
				jContentPane.add(jLabel, null);
			}
		}
		return jContentPane;
	}
	protected void processWindowEvent(WindowEvent e) {
	    if (e.getID() == WindowEvent.WINDOW_CLOSING ) {
	    	cancel = true;
	    	this.setVisible(false);
	    }
	}
	public WebDavDownLoadEvent getWebDavChooserEvent(){
		return webDavDownLoadEvent;
	}

	public WebDavUploadLoadEvent getWebDavUploadLoadEvent() {
		return webDavUploadLoadEvent;
	}

	public void setWebDavUploadLoadEvent(WebDavUploadLoadEvent webDavUploadLoadEvent) {
		this.webDavUploadLoadEvent = webDavUploadLoadEvent;
		if(webDavViewTableFactory != null){
			if(this.webDavUploadLoadEvent != null){
				if(getFilenameField() != null){
					if(this.webDavUploadLoadEvent.getUploadname() != null){
						getFilenameField().setText(this.webDavUploadLoadEvent.getUploadname());
					}
				}
			}
			webDavViewTableFactory.seWebDavUploadLoadEvent(webDavUploadLoadEvent);
		}
	}

	/**
	 * This method initializes filenameField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getFilenameField() {
		if (filenameField == null) {
			if(mode == 1){
				filenameField = new JTextField();
				filenameField.setBounds(new Rectangle(116, 279, 267, 24));
			}
		}
		return filenameField;
	}
	public void setLockToken(String lockToken){
		if(webDavViewTableFactory != null){
			webDavViewTableFactory.setLockToken(lockToken);
		}
	}

	public boolean isError() {
		return error;
	}

	public boolean isCancel() {
		return cancel;
	}

	/**
	 * This method initializes jButton3	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton3() {
		if (jButton3 == null) {
			jButton3 = new JButton();
			jButton3.setBounds(new Rectangle(390, 306, 110, 30));
			jButton3.setText("Lock");
			jButton3.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					webDavViewTableFactory.lock();
				}
			});
		}
		return jButton3;
	}
	
}  //  @jve:decl-index=0:visual-constraint="10,10"


