/* $Id: ResultPanel.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.text_search.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import smart_gs.logical.UsersNote;
import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import javax.swing.text.StyleContext;
import javax.swing.text.Highlighter;
import javax.swing.text.DefaultHighlighter.DefaultHighlightPainter;
import smart_gs.logical.URISolver;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;
import sml_editor.swingui.GSHTMLEditorTextPane;
import smart_gs.smleditor.swingui.GSTextEditor;;



@SuppressWarnings("serial")
public class ResultPanel extends JPanel{
	
	private int length;
	private ResultPanel(TextToShow textToShow, String documentURI,int index){
		super();
		length = textToShow.getLength();
		this.setPreferredSize(new Dimension(200, 50));
		this.setLayout(new BorderLayout());
		this.setBorder(new TitledBorder(documentURI));
		this.setSize(400,50);
		JTextField field = new JTextField();
		field.setHorizontalAlignment(SwingConstants.LEFT);
		field.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,20));
		field.setText(textToShow.getText());
		field.setBackground( Color.white );
		field.setOpaque( true );
		field.setEditable(false);
		field.setEnabled(false);
		field.setDisabledTextColor(Color.BLACK);
		this.add(field,BorderLayout.WEST);
		setHighlight(textToShow, field);
		//resultUsersNoteDocumentɑꍇ́AʂMouseListener
		if(documentURI.startsWith("smart://usersNote/")){
			field.addMouseListener(new UsersNoteResultPanelMouseListener(index,documentURI));
		}else{
			field.addMouseListener(new ResultPanelJTextFieldMouseListener(index,documentURI));
		}
	}
	public static ResultPanel getInstance(TextToShow textToShow, String documentURI,int index) {
		return new ResultPanel(textToShow, documentURI,index); 
	}
	
	private void setHighlight(TextToShow textToShow, JTextField field){
		Highlighter hilite = field.getHighlighter();
		DefaultHighlightPainter hilightPainter = new DefaultHighlightPainter(Color.yellow);
		try{
			hilite.addHighlight(textToShow.getIndex(), textToShow.getIndex()+textToShow.getLength(), hilightPainter);	
		}catch(Exception e){
			System.out.println(e);
		}
	}
	
	/*
	 * ResultUsersNoteDocumentɑĂꍇɁA
	 * YUsersNoteJ߂MouseListener
	 */
	class UsersNoteResultPanelMouseListener implements MouseListener{
		UsersNote usersNote;
		String documentURI;
		int index;
		String name;
		public UsersNoteResultPanelMouseListener(int index, String documentURI){
			this.index = index;
			this.documentURI = documentURI;
			this.usersNote = (UsersNote)URISolver.getUsersNote(documentURI);
			this.name = this.usersNote.getName();
		}
		public void mouseClicked(MouseEvent e) {
			if(e.getButton() == MouseEvent.BUTTON1){
				if(e.getClickCount() == 2){
					GSTextEditor gsTextEditor = new GSTextEditor(usersNote, name);
					GSHTMLEditorTextPane gsHTMLEditorTextPane = gsTextEditor.getGSEditorTextPane().getGSHTMLEditorTextPane();
					gsTextEditor.setVisible(true);
					if(gsHTMLEditorTextPane != null){
						gsHTMLEditorTextPane.requestFocus();
						gsHTMLEditorTextPane.addFocusListener(new GSEditorFocusListener(gsHTMLEditorTextPane,(index+1)));
					}
				}
			}
		}
		public void mouseEntered(MouseEvent e) {}

		public void mouseExited(MouseEvent e) {}

		public void mousePressed(MouseEvent e) {}

		public void mouseReleased(MouseEvent e) {}
	}
	
	class ResultPanelJTextFieldMouseListener implements MouseListener{
		protected Spread spread;
		protected String documentURI;
		protected int index;
		public ResultPanelJTextFieldMouseListener(int index,String documentURI){
			this.spread = (Spread)URISolver.getSpread(documentURI);
			this.documentURI = documentURI;
			this.index = index;
		}
		
		public void mouseClicked(MouseEvent e) {
			if(e.getButton() == MouseEvent.BUTTON1){
				if(e.getClickCount() == 2){
					if(spread != null){
						GSEditor gsEditor = new GSEditor(spread);
						GSHTMLEditorTextPane gsHTMLEditorTextPane = null;
						if(documentURI.endsWith("/firstidat/")){
							gsEditor.getSMLTabbedPane().setPanelToShow(1);
							gsHTMLEditorTextPane = gsEditor.getSMLTabbedPane().getFirstIDAT().getGSHTMLEditorTextPane();
						}else if(documentURI.endsWith("/secondidat/")){
							gsEditor.getSMLTabbedPane().setPanelToShow(2);
							gsHTMLEditorTextPane = gsEditor.getSMLTabbedPane().getSecondIDAT().getGSHTMLEditorTextPane();
						}else if(documentURI.endsWith("/thirdidat/")){
							gsEditor.getSMLTabbedPane().setPanelToShow(3);
							gsHTMLEditorTextPane = gsEditor.getSMLTabbedPane().getThirdIDAT().getGSHTMLEditorTextPane();
						}
						gsEditor.setVisible(true);
						if(gsHTMLEditorTextPane != null){
							gsHTMLEditorTextPane.requestFocus();
							gsHTMLEditorTextPane.addFocusListener(new GSEditorFocusListener(gsHTMLEditorTextPane,(index+1)));
						}
					}
				}
			}
		}

		public void mouseEntered(MouseEvent e) {}

		public void mouseExited(MouseEvent e) {}

		public void mousePressed(MouseEvent e) {}

		public void mouseReleased(MouseEvent e) {}

	}
	class GSEditorFocusListener implements FocusListener{
		protected GSHTMLEditorTextPane gsHTMLEditorTextPane;
		protected int index;
		public GSEditorFocusListener(GSHTMLEditorTextPane gsHTMLEditorTextPane,int index){
			this.gsHTMLEditorTextPane = gsHTMLEditorTextPane;
			this.index = index;
		}
		public void focusGained(FocusEvent e1) {
			gsHTMLEditorTextPane.setCaretPosition(index);
			Highlighter hilite = gsHTMLEditorTextPane.getHighlighter();
			DefaultHighlightPainter hilightPainter = new DefaultHighlightPainter(Color.yellow);
			try{
			hilite.addHighlight(this.index, index + length, hilightPainter); // 20080919 hashimoto
			}catch(Exception e2){
				e2.printStackTrace();
			}
			
		}
		public void focusLost(FocusEvent e) {
			gsHTMLEditorTextPane.getHighlighter().removeAllHighlights();
			gsHTMLEditorTextPane.removeFocusListener(this);
		}
		
	}
}
