/* $Id: UsersNoteNodeChangeNameAction.java 155 2011-05-03 10:31:26Z ohura $ */
package smart_gs.swingui.tree.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import smart_gs.logical.GSResource;
import smart_gs.logical.UsersNoteTree;
import smart_gs.swingui.WorkspaceWindow;

public class UsersNoteNodeChangeNameAction implements ActionListener {
	DefaultMutableTreeNode node;
	UsersNoteTree tree;

	public UsersNoteNodeChangeNameAction(DefaultMutableTreeNode selectedNode,
			UsersNoteTree tree) {
		node = selectedNode;
		this.tree = tree;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		String newName;
		if (((GSResource)(node.getUserObject())).getName() == "root") {
			JOptionPane.showMessageDialog(WorkspaceWindow.getInstance(),
					"The name of root cannot be changed","The name of root cannot be changed",JOptionPane.ERROR_MESSAGE);
			return;
		}
		newName = (String)JOptionPane.showInputDialog("Input New Name:\n");
		if (newName.equals("root")){
			JOptionPane.showMessageDialog(WorkspaceWindow.getInstance(),
					"root is a reserved name. Use another name","root is reserved",JOptionPane.ERROR_MESSAGE);
			return;
		}
		tree.changeNodeName(node,newName);
	}
}