/* $Id: AddSpreadsAction.java 152 2011-05-03 09:23:21Z ohura $ */
package smart_gs.swingui.tree.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.StringTokenizer;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import smart_gs.logical.Preference;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.StringUtils;

public class AddSpreadsAction implements ActionListener{
	protected File openDirectory;
	protected SpreadTree tree;
	protected SpreadDirectory spreadDirectory;
	File imageFolder = new File(Preference.getInstance().getInstance().getImageFolderPathString());
	String imagepath = Preference.getInstance().getInstance().getImageFolderPathString();
	
	public AddSpreadsAction(File openDirectory,SpreadTree tree,SpreadDirectory spreadDirectory){
		this.openDirectory = openDirectory;
		this.tree = tree;
		this.spreadDirectory = spreadDirectory;
//		TODO 2011.03.14 shayashi: Htqk𒼂A`FbNII
		imagepath = StringUtils.replaceString(imagepath, "\\", "/");
		imagepath = StringUtils.replaceString(imagepath, "//", "/");
	}
	
	public void addImage(String rootDir,String addFileDir, File addFile){
		if(tree.isRegistered(addFile)) return;
		
		DefaultMutableTreeNode treeNode = tree.getSelectedNode();
		SpreadDirectory parent = spreadDirectory;
		if(!rootDir.equals(addFileDir)){
			
			//String dir = addFileDir.substring(addFileDir.indexOf(rootDir) + rootDir.length(),addFileDir.length());
			String dir = addFileDir.substring( rootDir.length(),addFileDir.length());
			StringTokenizer st = new StringTokenizer(dir, "/");
			StringBuffer dirBuf = new StringBuffer();
			if(!rootDir.endsWith("/")){
				rootDir+="/";
			}
			dirBuf.append(rootDir);
			
	        while (st.hasMoreTokens()) {
	        	dirBuf.append(st.nextToken() + "/");
	        	File newDir = new File(dirBuf.toString());
	        	
		        treeNode = tree.addSpreadDirectory(treeNode, parent, newDir);
		        parent = (SpreadDirectory)treeNode.getUserObject();
	        }
		}
		tree.addLoadImage(treeNode,parent, addFile);
	}
	public void actionPerformed(ActionEvent e) {
		JFileChooser chooser = new JFileChooser(openDirectory);
		chooser.setMultiSelectionEnabled(true);
		
		int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
		if (input == JFileChooser.CANCEL_OPTION) {
			return;
		}
		
		File files[] = chooser.getSelectedFiles();
		int size = files.length;
		
		for (int count = 0; count <size; count++) {
			File file = files[count];
			this.addOneImage(file);
		}
	}
	
	public void addOneImage (File file) {
		if(file != null){
			String dir1 = openDirectory.getAbsolutePath();
			String dir2 = imageFolder.getAbsolutePath();
			String dir3 = file.getAbsolutePath();
			dir1 = StringUtils.replaceString(dir1, "\\", "/");
			dir1 = StringUtils.replaceString(dir1, "./", "/");
			dir1 = StringUtils.replaceString(dir1, "//", "/");
			dir2 = StringUtils.replaceString(dir2, "\\", "/");
			dir2 = StringUtils.replaceString(dir2, "./", "/");
			dir2 = StringUtils.replaceString(dir2, "//", "/");
			dir3 = StringUtils.replaceString(dir3, "\\", "/");
			dir3 = StringUtils.replaceString(dir3, "./", "/");
			dir3 = StringUtils.replaceString(dir3, "//", "/");
			
			boolean check = true;
			if(!dir1.toLowerCase().startsWith(dir2.toLowerCase())){
				check = false;
			}
			if(!dir3.toLowerCase().startsWith(dir1.toLowerCase())){
				check = false;
			}
			if(!check){
				int answer = JOptionPane.showConfirmDialog(new Frame(), "Only a folder in or below the image folder can be added.  ","Information",JOptionPane.DEFAULT_OPTION);
				return;
			}
			if(!imagepath.endsWith("/")){
				imagepath+="/";
			}
			if(!dir1.equals(dir2)){
				String rootpath = dir1.substring(dir1.indexOf(dir2) + dir2.length() ,dir1.length());
				StringBuffer sb = new StringBuffer();
				boolean delete = true;
				for(int i=0;i<rootpath.length();i++){
					if(delete){
						if(rootpath.charAt(i) != '/'){
							delete = false;
						}
					}
					if(!delete){
						sb.append(rootpath.charAt(i));
					}
				}
				imagepath+=sb.toString();
			}
			if(!imagepath.endsWith("/")){
				imagepath+="/";
			}
			{
				String addPath = dir3.substring(dir3.indexOf(dir1) + dir1.length() ,dir3.length());
				StringBuffer sb = new StringBuffer();
				boolean delete = true;
				for(int i=0;i<addPath.length();i++){
					if(delete){
						if(addPath.charAt(i) != '/'){
							delete = false;
						}
					}
					if(!delete){
						sb.append(addPath.charAt(i));
					}
				}
				file = new File(imagepath + sb.toString());				
			}
			File top = new File(imagepath);
			if(tree.isRegistered(file)){
				JOptionPane.showConfirmDialog(new Frame(), "The selected file has already been being used.  ","Information",JOptionPane.DEFAULT_OPTION);
				return;
			}
			addImage(top.getParent(), file.getPath(), file);
		}
	}
}
