/* $Id: LineSegmentToolBar.java 139 2011-04-17 16:49:09Z tsukushi1985 $ */
package smart_gs.swingui.toolbar;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

import smart_gs.GSConstants;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.action.CreateSegmentInfoAction;
import smart_gs.swingui.toolbar.action.PolygonalLineActionListener;
import smart_gs.swingui.toolbar.action.ShowLinesActionListener;
import smart_gs.drawing_tool.action.ChangeSizeAction;

@SuppressWarnings("serial")
public class LineSegmentToolBar extends JToolBar{
	private static JToggleButton polygonalLine = null;
	private static boolean polygonalLineSelect = false; 
	
	public LineSegmentToolBar(AbstractGSWindow parent){
		//20081031 North Grid Removed
        //20100520 Shimizu
		if(polygonalLine == null){
			polygonalLine = new JToggleButton("Specify Line");
 			//polygonalLine.setSelected(true);
			polygonalLine.addActionListener(new PolygonalLineActionListener());
			polygonalLine.setToolTipText("Specify Line");
			//20081031 North Grid Removed
			this.add(polygonalLine);
		}

		JButton showLines = new JButton("Show Lines");
		showLines.addActionListener(new ShowLinesActionListener());
		showLines.setToolTipText("Show Lines");
		this.add(showLines);
		
		//20081031 North Grid Removed
		//20100521 Shimizu
		JButton createDSC = new JButton("Create DSC");
		createDSC.addActionListener(new CreateSegmentInfoAction(parent));
		createDSC.setToolTipText("Create DSC");
		this.add(createDSC);
		
		//20110221 Shimizu add
		JButton changeSize = new JButton("Edit Lines");
		changeSize.addActionListener (new ChangeSizeAction(parent));
		changeSize.setToolTipText("Change Size");
		this.add(changeSize);
	}
	public static boolean isPolygonalLineSelect(){
		return polygonalLineSelect;
	}
	public static void polygonalLineClaer(){
		polygonalLine.setSelected(false);
		polygonalLineSelect = false;
	}
	public static void polygonalLineSet(){
		polygonalLine.setSelected(true);
		polygonalLineSelect = true;
	}
	
}
