/* $Id: UsersNoteTreePanel.java 148 2011-05-01 13:25:14Z shayashi $ */
package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import smart_gs.logical.UsersNoteTree;
import smart_gs.logical.GSResource;
//import smart_gs.logical.Spread;
//import smart_gs.logical.SpreadTree;
//import smart_gs.swingui.toolbar.action.ShowSpreadAction;
import smart_gs.logical.UsersNote;
import smart_gs.smleditor.swingui.GSTreeTextEditor;

@SuppressWarnings("serial")
public class UsersNoteTreePanel extends JPanel implements MouseListener {
//public class SpreadTreePanel extends JPanel{
	
	private UsersNoteTree tree;
	private JScrollPane scrollPane;
	
	public UsersNoteTreePanel(){
		this.setLayout(new BorderLayout());
		scrollPane = new JScrollPane();
		setAutoscrolls(true);
		scrollPane.getVerticalScrollBar().setUnitIncrement(20);
		this.tree = UsersNoteTree.getInstance();
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		JPanel tree_panel = new JPanel();
		tree_panel.setLayout(new FlowLayout(FlowLayout.LEFT));
		tree_panel.setBackground(Color.white);
		tree_panel.add(tree);
		tree_panel.setBorder(BorderFactory.createLineBorder(Color.BLACK,2));
		tree.addMouseListener(this);
	
        
        panel.add(tree_panel,BorderLayout.CENTER);

		scrollPane.setViewportView(panel);
		this.add(scrollPane,BorderLayout.CENTER);
	}
		
	public void mouseClicked(MouseEvent e) {
//		2011.03.07 shayashi changed
//		NbNSpreadI(double-click) or Spread Tree ́@selection model փCxgn(single-click)B
		if(e.getButton() == 1){
			UsersNote selectedUsersNote;
			if(e.getClickCount() == 2){
				GSResource selected;
				TreePath[] paths = this.tree.getSelectedPaths();
				if (paths != null && paths.length !=0) {
					
					selected = (GSResource)(((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject());
				} else return;				
				if (selected instanceof UsersNote) {
					 selectedUsersNote = (UsersNote)selected;
				} else {
					return;
				}
				if(selectedUsersNote != null){		
					GSTreeTextEditor editor = new GSTreeTextEditor(selectedUsersNote, selectedUsersNote.getName());
					editor.setVisible(true);
				}
			} else if (e.getClickCount() == 1){
				tree.getSelectionModel().setSelectionMode(TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION);
			}
			return;
		}
		
		//ENbNŃV[gI
		if(e.getButton() == 3){
			JPopupMenu menu = new UsersNoteTreeSelectPopupMenu(this.tree);
			menu.show(e.getComponent(),e.getX(),e.getY());
		}
	}

	public UsersNote getUsersNoteInTree(int row){
		List list = this.tree.getUsersNotes();
		try{
			for(int i=0;i<list.size();i++){
				UsersNote spread = (UsersNote)list.get(i);
				if(spread.getPageViewIndex() == row){
					return spread;
				}
			}
		}catch(Exception e){
			return null;
		}
		return null;
	}
	
	public UsersNoteTree getTree(){
    	return tree;
    }
	public void mouseEntered(MouseEvent arg0) {
	}

	public void mouseExited(MouseEvent arg0) {
	}

	public void mousePressed(MouseEvent e) {
//		2011.03.08 shayashi comments out.
//		TreePath path = this.tree.getClosestPathForLocation(e.getPoint().x,e.getPoint().y);
//		this.tree.setSelectionPath(path);
	}

	public void mouseReleased(MouseEvent arg0) {
	}
	
}


