/* $Id: EditLineFrame.java 155 2011-05-03 10:31:26Z ohura $ */
package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;


import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.text.StyleContext;

import smart_gs.drawing_tool.action.EditLineAction;



@SuppressWarnings("serial")
public class EditLineFrame extends JFrame{
	AbstractGSWindow parent;
	
	
	public EditLineFrame(AbstractGSWindow parent){
		super("EditLine");
		this.parent = parent;
		JPanel buttonpanel = new JPanel();
		buttonpanel.setLayout(new GridLayout(1,2));
		JButton change1 = new JButton("-");
		change1.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,40));
		change1.addActionListener(new EditLineAction(this.parent,0,0));
		JButton change2 = new JButton("+");
		change2.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,40));
		change2.addActionListener(new EditLineAction(this.parent,0,1));
		buttonpanel.add(change1);
		buttonpanel.add(change2);
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		JButton up = new JButton("");
		up.addActionListener(new EditLineAction(this.parent,1,0));
		JButton down = new JButton("");
		down.addActionListener(new EditLineAction(this.parent,1,1));
		JButton right = new JButton("");
		right.addActionListener(new EditLineAction(this.parent,1,2));
		JButton left = new JButton("");
		left.addActionListener(new EditLineAction(this.parent,1,3));
		panel.add(up,BorderLayout.NORTH);
		panel.add(down,BorderLayout.SOUTH);
		panel.add(right,BorderLayout.EAST);
		panel.add(left,BorderLayout.WEST);
		panel.add(buttonpanel,BorderLayout.CENTER);
		this.add(panel);
		this.setSize(300,200);
		
	}
	
	
	
}
