/* $Id: DesktopPanel.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

import smart_gs.logical.GSResource;
import smart_gs.reasoning_web.RootFolder;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;
import smart_gs.reasoning_web.desktop.swingui.FolderPanel;
import smart_gs.reasoning_web.desktop.swingui.ShortCutListPanel;

@SuppressWarnings("serial")
public class DesktopPanel extends JPanel{
	
	private DeskTopFolder rootFolder;
	private DeskTopFolder currentFolder;
	private FolderPanel mainPanel;	
	private JScrollPane scrollPane;
	private JToolBar toolBar;
	
	private ShortCutListPanel listPanel;
	private MemoPanel memoPanel;
	/*
	 * mainPanelFolderPanel clasŝ̂JScrollPanel class̓
	 */
	public DesktopPanel(){
		this.scrollPane = new JScrollPane();
		this.toolBar = new DeskTopToolbar();
		this.rootFolder = RootFolder.getInstance();
		this.currentFolder = this.rootFolder;
		this.mainPanel = new FolderPanel(this.rootFolder);
		this.scrollPane.setViewportView(this.mainPanel);		
		this.setLayout(new BorderLayout());
		

		this.listPanel = new ShortCutListPanel(this.currentFolder);
		this.memoPanel = new MemoPanel();
		this.listPanel.setMemoPanel(this.memoPanel);
		
		JSplitPane leftPanel = new JSplitPane(JSplitPane.VERTICAL_SPLIT,this.listPanel,this.memoPanel);
		leftPanel.setDividerLocation(200);
		JSplitPane mainPanel = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,leftPanel,this.scrollPane);
		mainPanel.setDividerLocation(300);
		this.add(mainPanel,BorderLayout.CENTER);
	}
	
	public DeskTopFolder getCurrentFolder() {	
		return this.currentFolder;
	}

	public void setMainPanel(FolderPanel panel) {
		this.scrollPane.setViewportView(panel);
		this.mainPanel = panel;
		this.currentFolder = panel.getFolder();
		//this.updateAll();
		//2007.11.24 Tsukushi Shimizu
		this.updateAll(currentFolder);
	}

	public void back() {
		FolderPanel panel = (FolderPanel)this.mainPanel;
		DeskTopFolder folder = panel.getFolder().getParent();
		if(folder != null){
			this.setMainPanel(new FolderPanel(folder));
		}	
	}

	public JToolBar getToolBar() {
		return this.toolBar;
	}

	public void updateAll() {
		this.listPanel.update();
	}
	
	//2007.11.24 Tsukushi Shimizu
	public void updateAll(DeskTopFolder folder) {
		this.listPanel.update(folder);
	}

	public void setSelectedElement(DesktopElement selectedElement) {
		this.listPanel.setSelectedElement(selectedElement);
		
	}
	public DesktopElement getSelectedElement(){
		return this.listPanel.getSelectedElement();
	}

	public GSResource getResource(String uri) {
		return this.rootFolder.getResource(uri);
	}
}
