/* $Id: ExpNoteManager.java 152 2011-05-03 09:23:21Z ohura $ */
package smart_gs.reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import reasoning_web.logical.ExplanatoryNote;
import smart_gs.GSConstants;
import smart_gs.logical.GSResource;
import smart_gs.logical.URICreator;

public class ExpNoteManager {
	
	private static ExpNoteManager singleton = new ExpNoteManager();
	
	private List<GSExplanatoryNote> notes;
	
	private ExpNoteManager(){
		notes = new ArrayList<GSExplanatoryNote>();
	}
	public static ExpNoteManager getInstance() {
		return singleton;
	}
	public GSExplanatoryNote getExplanatoryNote(int id) {
		for(int i=0;i<notes.size();i++){
			if(notes.get(i).getId() == id){
				return notes.get(i);
			}
		}
		return null;
	}
	
	public void restore(Element element){
		NodeList list = element.getElementsByTagName("explanatory");
		for(int i=0;i<list.getLength();i++){
			Element elem = (Element)list.item(i);
			GSExplanatoryNote note = GSExplanatoryNote.restore(elem);
			this.notes.add(note);
		}

	}
	//2007/11/12 kazuhiro kobayashi
	public void addNote(GSExplanatoryNote note){
		this.notes.add(note);
		System.out.println("Add: " + note);
	}
	
	public void save(Document document,Element parent) {
		Element element = document.createElement("expNotes");
		for(int i=0;i<this.notes.size();i++){
			GSExplanatoryNote note = this.notes.get(i);
			Element elem = note.createXMLElement(document);
			element.appendChild(elem);
		}
		parent.appendChild(element);
		
		
	}
	public GSResource getResource(String uri) {
		for(int i=0;i<this.notes.size();i++){
			if(this.notes.get(i).equals(uri)){
				return this.notes.get(i);
			}
			GSResource segment = this.notes.get(i).getTextSegmentByURI(uri);
			if(segment != null){
				return segment;
			}
		}
		return null;
	}
	public GSExplanatoryNote getExplanatoryNoteByTextSegmentURI(String uri) {
		String expNoteURI = extractExplanatoryNoteURIfromTextSegment(uri);
		int headerLen = GSConstants.URI_HEADER.length();

		//debug
		System.out.println("debug print from ExpNoteManager, getExplanatoryNoteByTextSegmentURI(uri)");
		System.out.println("  uri: " + uri);
		System.out.println("  expNoteURI extracted from uri: " + expNoteURI);
		
		for(int i=0;i<this.notes.size();i++){
			
			System.out.println("  notes.get("+i+") uri: "+ this.notes.get(i).getURI().substring(headerLen));
			System.out.println("  notes.get("+i+") old version uri: "+ this.notes.get(i).getOldVersionURI().substring(headerLen));
			
			if(URICreator.getURIWithoutHeader(this.notes.get(i)).equals(expNoteURI)
				|| this.notes.get(i).getOldVersionURI().substring(headerLen).equals(expNoteURI)
			){
				System.out.println("  return notes.get("+i+")");
				return this.notes.get(i);
			}
		}
		System.out.println("  return null");
		return null;
	}
	private String extractExplanatoryNoteURIfromTextSegment(String uri) {
		return uri.substring(uri.indexOf(URICreator.SEP2 + URICreator.EXPLANATORY_NOTE)+1);
	}

}
